#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    нужно подключить прод базу и БК

=cut

use lib::abs qw(../../lib/);
use feature say;
use qbit;
use Application;
use File::Temp qw(tempfile);

use PiConstants qw(  $ADINSIDE_CLIENT_ID );

main();

sub main {

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $app = Application->new();

    $app->pre_run();

    do_resend($app);

    $app->post_run();
}

sub do_resend {
    my $app = shift;

    my %page_ids = ();

    my $user = $app->users->get_all(
        fields => ['id'],
        filter => {'client_id' => $ADINSIDE_CLIENT_ID}
    )->[0];

    my $pages = $app->video_an_site->get_all(
        fields => ['id'],
        filter => {
            'multistate' => 'not deleted',
            'owner_id'   => $user->{id},
        }
    );

    my $page_ids = join ',', map {$_->{id}} @$pages;

    my (undef, $log_file_name) =
      tempfile('PI-10143_fix_is_yandex_page_for_video_adinside_XXXXXX', OPEN => 0, DIR => './');

    say "resend_to_bk.pl video pages: $page_ids";
    say "resend_to_bk.pl log file: $log_file_name";

    # NOTE! У adinside всего 40 видео пейджей
    my $system_string = "perl bin/resend_to_bk.pl --page_ids=$page_ids 2>&1 1>$log_file_name";

    say "Starting system('$system_string')";

    system($system_string);

    say '#END';
}
