#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    # На докерной базе
    # 43927 rows in set (37.20 sec)

    my $data = $app->partner_db->_get_all("
select
    page_id
from
    context_on_site_campaign
where
    page_id is not null
    and page_id not in (select page_id from all_pages where login in ('adv-vertis', 'kp-team', 'yamarketadv'))
    and ((multistate & pow(2,0) /* working */ ) || (multistate & pow(2,1) /* testing */ ))
    and !(multistate & pow(2,5) /* read_only */ )
    and !(multistate & pow(2,10) /* protected */ )
    and !(multistate & pow(2,11) /* need_update */ )

union

select
    context_page_id as page_id
from
    mobile_app_settings
where
    context_page_id is not null
    and context_page_id not in (select page_id from all_pages where login in ('adv-vertis', 'kp-team', 'yamarketadv'))
    and ((multistate & pow(2,0) /* working */ ) || (multistate & pow(2,1) /* testing */ ))
    and !(multistate & pow(2,8) /* protected */ )
    and !(multistate & pow(2,9) /* need_update */ )
"
    );

    my $content = join "\n", sort {$a <=> $b} map {$_->{page_id}} @{$data};
    $content .= "\n";

    my $file_name = 'PI-10701_page_ids_list';
    writefile($file_name, $content);

    say "File $file_name created";
    say '';
    say "Now you should run `./bin/resend_to_bk.pl --file_path=$file_name &> PI-10701_resend_log`";

    $app->post_run();
    say "#END";
}
main();
__END__
