#dependencies PI-28946_internal_mobile_app_add_from_trigger.sql

-- INSERT TRIGGER --
DROP TRIGGER IF EXISTS `internal_mobile_app_insert`;
DELIMITER $$
CREATE TRIGGER internal_mobile_app_insert
    BEFORE INSERT
    ON internal_mobile_app
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.id, -- internal_mobile_app is a domain for itself
                1,
                NEW.id,
                'internal_mobile_app',
                NEW.multistate,
                NEW.opts,
                NEW.id, -- is page_id for internal
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '0000-00-00 00:00:00'),
                creator_id);
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

-- UPDATE TRIGGER ---
DROP TRIGGER IF EXISTS `internal_mobile_app_update`;
DELIMITER $$
CREATE TRIGGER internal_mobile_app_update
    BEFORE UPDATE
    ON internal_mobile_app
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
    UPDATE pages
    set blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        domain_id               = NEW.id,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        page_id                 = NEW.id,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where model = 'internal_mobile_app'
      AND id = OLD.id;
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `pages_update`;
DELIMITER $$
CREATE TRIGGER pages_update
    BEFORE UPDATE
    ON pages
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        IF (OLD.model = 'context_on_site_campaign')
        THEN
    UPDATE context_on_site_campaign
    set allowed_turbo           = NEW.allowed_turbo,
        blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        page_id                 = NEW.id,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where id = OLD.id;
    ELSEIF (OLD.model = 'internal_context_on_site_campaign')
        THEN
    UPDATE internal_context_on_site_campaign
    set allowed_turbo           = NEW.allowed_turbo,
        blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        site_id                 = NEW.domain_id,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where id = OLD.id;
    ELSEIF (OLD.model = 'mobile_app_settings')
        THEN
    UPDATE mobile_app_settings
    set blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        application_id          = NEW.domain_id,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        owner_id                = NEW.owner_id,
        context_page_id         = NEW.page_id,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where id = OLD.id;
    ELSEIF (OLD.model = 'internal_mobile_app')
            THEN
    UPDATE internal_mobile_app
    set blocks_count            = NEW.blocks_count,
        blocks_limit            = NEW.blocks_limit,
        caption                 = NEW.caption,
        create_date             = NEW.create_date,
        from_trigger            = 1,
        id                      = NEW.id,
        multistate              = NEW.multistate,
        opts                    = NEW.opts,
        unmoderated_rtb_auction = NEW.unmoderated_rtb_auction,
        update_time             = NEW.update_time,
        creator_id              = NEW.creator_id
    where id = OLD.id;
END IF;
ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

INSERT IGNORE INTO pages (blocks_count,
                          blocks_limit,
                          caption,
                          create_date,
                          domain_id,
                          from_trigger,
                          id,
                          model,
                          multistate,
                          opts,
                          page_id,
                          unmoderated_rtb_auction,
                          update_time)
select blocks_count,
       blocks_limit,
       caption,
       create_date,
       id,
       1,
       id,
       'internal_mobile_app',
       multistate,
       opts,
       id,
       unmoderated_rtb_auction,
       update_time
from internal_mobile_app;

select count(*) broken_pages
from internal_mobile_app ima,
     pages p
where ima.id = p.page_id
  and (
            ima.blocks_count <> p.blocks_count
        or ima.blocks_limit <> p.blocks_limit
        or ima.caption <> p.caption
        or ima.create_date <> p.create_date
        or ima.id <> p.domain_id
        or ima.id <> p.id
        or ima.multistate <> p.multistate
        or ima.opts <> p.opts
        or ima.id <> p.page_id
        or ima.unmoderated_rtb_auction <> p.unmoderated_rtb_auction
        or ima.update_time <> p.update_time
    );
