-- show affected pages which should be resended
select GROUP_CONCAT(distinct page_id, '') from filters where filter_id in (1,3,4,6,7,8,9,12,14,18,19,20,22,27) \G;

-- delete old filters
delete from filters where filter_id in (1,4,8,9,12,14,19,20,22,27);

-- delete extra filters
update thematic_filters set
     multistate = 1
     where id in (1,4,8,9,12,14,19,20,22,27);

-- medicine to med_services
update thematic_filters set
     caption_en = 'Medical services',
     caption_tr = 'Medical services',
     caption_ru = 'Медицинские услуги',
     bk_name = 'med_services'
     where id = 3;

-- finance to loan
update thematic_filters set
     caption_en = 'Loans',
     caption_tr = 'Loans',
     caption_ru = 'Займы',
     bk_name = 'loan'
     where id = 18;

-- expand bk_name
update thematic_filters set bk_name = 'tobacco,legal_vape,no_tobacco' where bk_name = 'tobacco';
update thematic_filters set bk_name = 'weapons,pseudoweapon_accessories,pseudoweapon,no_weapon' where bk_name = 'weapons';

-- update filters
update thematic_filters set caption_en = 'Alcohol',                     caption_ru = 'Алкоголь'                             where id = 5;
update thematic_filters set caption_en = 'Magic',                       caption_ru = 'Магия и эзотерика'                    where id = 15;
update thematic_filters set caption_en = 'Underwear',                   caption_ru = 'Нижнее белье'                         where id = 16;
update thematic_filters set caption_en = 'Matchmaking',                 caption_ru = 'Знакомства'                           where id = 17;
update thematic_filters set caption_en = 'Bookmakers',                  caption_ru = 'Букмекерские конторы'                 where id = 21;
update thematic_filters set caption_en = 'annoying',                    caption_ru = 'Реклама не для Главной Яндекса (NDA)' where id = 23;
update thematic_filters set caption_en = 'Dietary supplements',         caption_ru = 'Биологически-активные добавки (БАД)'  where id = 24;
update thematic_filters set                                             caption_ru = 'Анимированные (NDA)'                  where id = 25;
update thematic_filters set caption_en = 'suspicious_quality',          caption_ru = 'Сомнительное качество (NDA)'          where id = 26;
update thematic_filters set caption_en = 'Non-alcoholic beer and wine', caption_ru = 'Безалкогольное пиво, вино'            where id = 28;


-- add new filters
insert ignore into thematic_filters(caption_en, caption_tr, caption_ru, bk_name) values
('Pharmacy',            'Pharmacy',             'Лекарственные средства',                   'pharmacy'),
('Medical equipment',   'Medical equipment',    'Медицинские изделия',                      'med_equipment'),
('Religion',            'Religion',             'Товары и услуги религиозного характера',   'religion');


-- set uppercase for first character
update thematic_filters set caption_ru = CONCAT(LOWER(LEFT(caption_ru, 1)), SUBSTRING(caption_ru, 2)) where id not in (14, 24);
update thematic_filters set caption_en = CONCAT(LOWER(LEFT(caption_en, 1)), SUBSTRING(caption_en, 2));
update thematic_filters set caption_tr = CONCAT(LOWER(LEFT(caption_tr, 1)), SUBSTRING(caption_tr, 2));
