DROP TABLE IF EXISTS `PI-29040`;

CREATE TEMPORARY TABLE
    `PI-29040`
SELECT
    `users`.`id` AS `user_id`
FROM
    `users`
JOIN
    `user_role`
    ON `users`.`id` = `user_role`.`user_id`
LEFT JOIN
    `user_features`
    ON
        `users`.`id` = `user_features`.`user_id`
        AND
        `user_features`.`feature` = 'editable_requisites'
WHERE
    `user_role`.`role_id` IN (9, 20, 27)
    AND
    `user_features`.`user_id` IS NULL
    AND NOT (
        `users`.`is_games`
        OR (
            `users`.`country_id` = '187'
            AND
            `users`.`opts` ->> '$.cooperation_form' = 'sw_ytph'
        )
    );

INSERT IGNORE INTO
    `user_features`(`user_id`, `feature`)
SELECT DISTINCT
    `PI-29040`.`user_id`, 'editable_requisites'
FROM
    `PI-29040`;

DROP TABLE IF EXISTS `PI-29040`;
