use partner_logs;

CREATE TABLE IF NOT EXISTS bk_edit_page_2017 (
  `id`       bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `dt`       timestamp           NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `page_id`  int unsigned,
  `login`    varchar(255)        NOT NULL,
  `request`  mediumblob,
  `response` varchar(4096)       NOT NULL,
  `error`    varchar(4096)       NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bk_edit_page__page_id_dt` (`page_id`,`dt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* Переносим 2017_11 */
REPLACE INTO
    bk_edit_page_2017 (
        dt,
        page_id,
        request,
        response,
        error
    )
    select
        dt,
        if (
            error <= "",
            substr(
                uncompress(content),
                locate('"PageID":"', uncompress(content) ) + 10,
                locate('"', uncompress(content), locate('"PageID":"', uncompress(content) ) + 10 )  -  ( locate('"PageID":"', uncompress(content) ) + 10 )
            ),
            substr(
                uncompress(params),
                locate('"PageID":"', uncompress(params) ) + 10,
                locate('"', uncompress(params),  locate('"PageID":"', uncompress(params)  ) + 10 )  -  ( locate('"PageID":"', uncompress(params)  ) + 10 )
            )
        ),
        params,
        uncompress(content),
        error
    from
        models_soap_api_2017_11
    where
        name_module = 'Application::Model::API::Yandex::BK'
        and method = 'EditPage';


/* Переносим 2017_10 */
REPLACE INTO
    bk_edit_page_2017 (
        dt,
        page_id,
        request,
        response,
        error
    )
    select
        dt,
        if (
            error <= "",
            substr(
                uncompress(content),
                locate('"PageID":"', uncompress(content) ) + 10,
                locate('"', uncompress(content), locate('"PageID":"', uncompress(content) ) + 10 )  -  ( locate('"PageID":"', uncompress(content) ) + 10 )
            ),
            substr(
                uncompress(params),
                locate('"PageID":"', uncompress(params) ) + 10,
                locate('"', uncompress(params),  locate('"PageID":"', uncompress(params)  ) + 10 )  -  ( locate('"PageID":"', uncompress(params)  ) + 10 )
            )
        ),
        params,
        uncompress(content),
        error
    from
        models_soap_api_2017_10
    where
        name_module = 'Application::Model::API::Yandex::BK'
        and method = 'EditPage';


/* Переносим 2017_09 */
REPLACE INTO
    bk_edit_page_2017 (
        dt,
        page_id,
        request,
        response,
        error
    )
    select
        dt,
        if (
            error <= "",
            substr(
                uncompress(content),
                locate('"PageID":"', uncompress(content) ) + 10,
                locate('"', uncompress(content), locate('"PageID":"', uncompress(content) ) + 10 )  -  ( locate('"PageID":"', uncompress(content) ) + 10 )
            ),
            substr(
                uncompress(params),
                locate('"PageID":"', uncompress(params) ) + 10,
                locate('"', uncompress(params),  locate('"PageID":"', uncompress(params)  ) + 10 )  -  ( locate('"PageID":"', uncompress(params)  ) + 10 )
            )
        ),
        params,
        uncompress(content),
        error
    from
        models_soap_api_2017_09
    where
        name_module = 'Application::Model::API::Yandex::BK'
        and method = 'EditPage';


