#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings;
use utf8;

use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $app = Application->new();
$app->pre_run();

$app->set_cur_user({id => 0});

my $i      = 1;
my @tables = qw(
  context_on_site_adfox
  context_on_site_direct
  context_on_site_rtb
  internal_context_on_site_direct
  internal_context_on_site_rtb
  internal_mobile_app_rtb
  internal_search_on_site_direct
  mobile_app_rtb
  search_on_site_direct
  );

# Из тикета:
# https://st.yandex-team.ru/PI-10631#1509037067000
#
# * добавляется настройка  urlBackgroundColor , дефолтный цвет     #0000cc
# * для вертикала и горизонтала и горизонтала
#   * urlColor - сбросить в null, т.к подбирается автоматом
#   * urlBackgroundColor - проставить всем блокам этих форматов скопировав с  titleColor
# * для всех остальных форматов  urlBackgroundColor - сбросить в null
# * настроенные  titleColor выставляем в дефолтный черный:     #000000
#
#
# Коммет к этому скрипту
#
# urlColor в null не сбрасываю, так как при некоторых размерах блока это значачение используется.

foreach my $table (@tables) {

    warn sprintf("## table %s (%s/%s)\n", $table, $i, scalar(@tables));

    my $direct_block_type_field;

    if (grep {$table eq $_}
        qw(context_on_site_direct internal_context_on_site_direct internal_search_on_site_direct search_on_site_direct))
    {
        $direct_block_type_field = 'type';
    } else {
        $direct_block_type_field = 'direct_block';
    }

    my $parent_model_id;

    if (grep {$table eq $_} qw(application_id internal_mobile_app_rtb)) {
        $parent_model_id = 'application_id';
    } elsif (
        grep {
            $table eq $_
        } qw(mobile_app_rtb)
      )
    {
        $parent_model_id = 'context_page_id';
    } else {
        $parent_model_id = 'campaign_id';
    }

    my $data = $app->partner_db->_get_all("
        select
            $parent_model_id,
            id,
            $direct_block_type_field,
            title_color,
            url_color,
            url_background_color
        from
            $table
        where
            $direct_block_type_field in ('horizontal', 'vertical', 'modernAdaptive')
    ");

    foreach my $el (@$data) {
        warn to_json($el, canonical => 1) . "\n";
    }

    warn "\n";

    $app->partner_db->_do("
        update
            $table
        set
            url_background_color = title_color,
            title_color = '000000'
        where
            $direct_block_type_field in ('horizontal', 'vertical', 'modernAdaptive')
    ");

    $i++;
}

print "#END\n";
