#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Test::Differences;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_option('cur_user' => {id => 0});
    my $tmp_rights = $app->add_all_tmp_rights();

    # Апдейтим две таблицы по общему принципу
    my $models = [
        {
            name  => 'statistics_reports',
            field => 'query',
        },
        {
            name  => 'stat_report_params_digest',
            field => 'params',
        },
    ];

    for my $model (@$models) {
        my ($name, $field) = @{$model}{qw(name field)};

        my @reports = @{$app->partner_db->$name->get_all(fields => ['id', $field],)};

        for my $report (@reports) {
            print 'Report ' . $report->{'id'};

            my $r0      = from_json($report->{$field});
            my $r       = clone($r0);
            my $changed = convert_report($report->{'id'}, $r);

            if ($changed) {
                print " - changed\n";
                #eq_or_diff($r0, $r, undef, {Sortkeys => 1});

                my $json = to_json($r);
                $app->partner_db->$name->edit($report->{'id'}, {$field => $json},);                

            } else {
                print " - ok\n";
            }
        }
    }

    $app->post_run();
    say "#END";
}

sub convert_report {
    my ($id, $report) = @_;

    my $is_changed = 0;

    # Обрабатываем chartLevel и tableLevel
    for my $view_level_name (qw(chartLevel tableLevel)) {
        # chartLevel и tableLevel в свою очередь являются массивами
        # два элемента будет в случае сравнения двух периодов
        # поэтому еще один цикл
        for my $view_level_element (@{$report->{$view_level_name}}) {

            # Не нашел случаев, когда левелов может быть != 1, но на всякий случай вставил ассерт
            my $number_of_levels = @{$view_level_element->{levels}};
            die "Report $id $view_level_name has $number_of_levels levels" if $number_of_levels != 1;

            my $level = $view_level_element->{'levels'}[0];

            # Ищем поля с префиксом adfox_ в fields
            # Ищу ТОЛЬКО В fields, потому что (насколько я понял) в dimension_fields и entity_fields ничего переименовывать не нужно
            my @adfox_fields = grep {$_ =~ m/^adfox_/} @{$view_level_element->{fields}};

            # Если такие поля нашлись, то выкидываем их из отчета
            if (@adfox_fields > 0) {

                # Если уровень - блоки ADFOX, то нужно поменять его на RTB и добавить фильтр
                if ($level->{'id'} eq 'advnet_context_on_site_adfox') {
                    $level->{'id'} = 'advnet_context_on_site_rtb';

                    if (   ref($level->{'filter'}) eq 'ARRAY'
                        && $level->{'filter'}[0] eq 'AND'
                        && ref($level->{'filter'}[1]) eq 'ARRAY')
                    {
                        push @{$level->{'filter'}[1]}, ['adfox_block' => '=' => JSON::true];
                    } else {
                        $level->{'filter'} = [
                            'AND' => [
                                ['adfox_block' => '=' => JSON::true],
                                (defined($level->{'filter'}) ? $level->{'filter'} : ())
                            ]
                        ];
                    }
                    # Если уровень более высокий (вознаграждения, РСЯ или контекстные площадки),
                    # то нужно добавить группировку
                } elsif (
                    grep {
                        $level->{'id'} eq $_
                    } (qw(payment advnet_on_site advnet_context_on_site))
                  )
                {
                    $view_level_element->{'dimension_fields'} //= [];
                    push @{$view_level_element->{'dimension_fields'}}, 'adfox_block';
                    # Кажется, что если кроме адфоксовых полей в высокоуровневом отчете никаких других не было,
                    # то можно добавить доп.фильтр, чтобы оставить в выдаче только адфоксовые блоки
                    # Пока оставляю закомменченым, т.к. при тестировании были странные баги
                    # Попробуй так сконвертить на нормальной общей бете и потестить
                    if (@adfox_fields == @{$view_level_element->{fields}}) {
                        if (   ref($view_level_element->{'dimension_filter'}) eq 'ARRAY'
                            && $view_level_element->{'dimension_filter'}[0] eq 'AND'
                            && ref($view_level_element->{'dimension_filter'}[1]) eq 'ARRAY')
                        {
                            push @{$view_level_element->{'dimension_filter'}[1]}, ['adfox_block' => '=' => JSON::true];
                        } else {
                            $view_level_element->{'dimension_filter'} = [
                                'AND' => [
                                    ['adfox_block' => '=' => JSON::true],
                                    (
                                        defined($view_level_element->{'dimension_filter'})
                                        ? $view_level_element->{'dimension_filter'}
                                        : ()
                                    )
                                ]
                            ];
                        }
                    }
                } else {
                    # Сюда не должно попасть
                    die "Report $id has adfox fields but $level->{id} level";
                }

                convert_fields($view_level_element->{'fields'});
                convert_fields($view_level_element->{'order_by'});

                # Переименовываем сортировочку, если нужно
                my $table_data = $report->{'tableViewModelData'};
                $table_data->{'sortBy'} =~ s/^adfox_/rtb_/
                  if defined($table_data)
                      && defined($table_data->{'sortBy'})
                      && $table_data->{'sortBy'} ne 'adfox_block';

                $is_changed = 1;
            }
        }
    }

    return $is_changed;
}

sub convert_fields {
    my ($fields) = @_;

    my @new_fields;
    my %seen_fields;

    for my $elem (@$fields) {
        my $change_field = ref($elem) eq 'HASH' ? \$elem->{'field'} : \$elem;

        $$change_field =~ s/^adfox_/rtb_/;

        if (!exists($seen_fields{$$change_field})) {
            push @new_fields, $elem;
            $seen_fields{$$change_field} = 1;
        }
    }

    @$fields = @new_fields;
}

main();
__END__
