#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use File::Temp qw(tempfile);
use SQL::Easy;

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {TRUE};
    }

    my $se = SQL::Easy->new({dbh => $app->partner_db->get_dbh(),});

    my %no_bookmaker = map {$_->{id} => $_} @{
        $se->get_data("
        SELECT id, page_id
        FROM context_on_site_campaign
        WHERE page_id NOT IN (
            SELECT DISTINCT page_id
            FROM filters
            WHERE filter_id = 21
        );
    ")
      };

    say scalar(keys(%no_bookmaker)) . ' PAGES WITHOUT BOOKMAKER FLAG';

    my $changed_filters = $se->get_data("
        SELECT l.id, l.elem_id, l.dt, l.opts
        FROM context_on_site_campaign_action_log AS l
        JOIN (
            SELECT elem_id, max(id) AS max_id
            FROM context_on_site_campaign_action_log
            WHERE action = 'edit' AND opts LIKE '%filters%' AND dt >= '2017-10-30'
            GROUP BY elem_id
        ) AS m
        ON l.id = m.max_id;
    ");

    say scalar(@$changed_filters) . ' PAGES WITH CHANGED FILTERS';

    my ($fh, $file_name) = tempfile('PI-11125_resend_to_bk_XXXXXX', DIR => './');

    for my $elem (@$changed_filters) {
        my $opts = from_json($elem->{opts});

        unless (grep {$_ eq 21} @{$opts->{filters}}) {
            say
"SKIPPING id=$elem->{elem_id} BECAUSE OF ACTION EDIT id=$elem->{id}, dt='$elem->{dt}', opts=$elem->{opts}";
            delete $no_bookmaker{$elem->{elem_id}};
        }
    }

    say scalar(keys(%no_bookmaker)) . ' PAGES TO EDIT';

    my @pages_to_edit = sort {$a->{page_id} <=> $b->{page_id}} values(%no_bookmaker);

    $fh->print(join("\n", map {$_->{page_id}} @pages_to_edit));

    close($fh) or die "close: $!";

    my $sql = "INSERT INTO filters (page_id, filter_id) VALUES\n"
      . join(",\n", map {"($_->{page_id}, 21)"} @pages_to_edit) . ";\n";

    say $sql;

    $se->execute($sql);

    say "perl bin/resend_to_bk.pl --file_path=$file_name 2>&1 | tee resend_to_bk.log";

    say "#END\n";

    $app->post_run();
}
main();
__END__
