#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
    ../../lib
);
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    my %tables_with_bk_data;

    my $meta = $app->partner_db->get_all_meta();
    foreach my $table ($app->partner_db->_sorted_tables(keys(%{$meta->{'tables'}}))) {

        foreach my $field (@{$app->partner_db->$table->fields()}) {
            if ( $field->name() eq 'bk_data' ) {
                $tables_with_bk_data{ $table } = 1;
            }
        }
    }

    foreach my $table (keys %tables_with_bk_data) {

        my @pk = @{$app->partner_db->$table->primary_key()};

        my $data = $app->partner_db->$table->get_all(
            fields => [@pk, 'bk_data'],
            filter => [
                'AND' => [
                    [is_custom_bk_data => 'IS NOT' => \undef],
                    [is_custom_bk_data => '<>' => \0],
                ]
            ],
        );

        foreach my $el (@$data) {

            my $bk_data_json = delete $el->{bk_data};
            my $bk_data;

            try {
                $bk_data = from_json $bk_data_json;
            } catch {
                warn to_json({ table => $table, el => $el, bk_data => $bk_data_json, warning => 'bk_data was not valid json'}, canonical => 1) . "\n";
            };


            if ($bk_data) {
                my $pk = clone($el);

                warn to_json({ table => $table, pk => $pk}, canonical => 1), "\n";

                $bk_data->{BlockModel} = $table;
                $el->{bk_data} = to_json($bk_data, pretty => 1);

                $app->partner_db->$table->edit($pk, $el);
            }
        }

    }

    $app->post_run();
    say "#END";
}
main();
__END__
