#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    Нужно подключить прод базу

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {TRUE};
    }

    my %page_ids = ();
    foreach my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $query = $app->partner_db->query->select(
            table  => $app->partner_db->$model,
            fields => ['campaign_id'],
            filter => {multistate => $app->$model->get_multistates_by_filter('working'), id => $TECHNICAL_RTB_BLOCK_ID}
        );

        $query->distinct(TRUE);

        foreach (@{$query->get_all}) {
            $page_ids{$_->{'campaign_id'}} = TRUE;
        }
    }

    my $pages = $app->partner_db->all_pages_view->get_all(
        fields   => [qw(page_id is_protected)],
        filter   => {page_id => [keys(%page_ids)]},
        order_by => [qw(page_id)]
    );

    my @is_protected = ();
    my @working      = ();
    foreach my $page (@$pages) {
        if ($page->{'is_protected'}) {
            push(@is_protected, $page->{'page_id'});
        } else {
            push(@working, $page->{'page_id'});
        }
    }

    my $file_name = 'PI-11113_media_performance';

    writefile($file_name . '_protected', join("\n", @is_protected));

    my $file_count = @working / 5 + 1;

    my $count = 1;
    while (my @page_ids = splice(@working, 0, $file_count)) {
        writefile($file_name . "_$count", join("\n", @page_ids));

        $count++;
    }

    say "perl bin/resend_to_bk.pl --file_path=... 2>&1 | tee resend_to_bk.log";

    say "#END\n";

    $app->post_run();
}
main();
__END__
