#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    Нужно подключить прод базу

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Test::Differences;

# main
sub main {

    my $dry_run = grep {$_ =~ /--dry_run/} @ARGV;
    say 'dry_run mode' if $dry_run;

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {TRUE};
    }

    my $query = $app->partner_db->query->select(
        table  => $app->partner_db->widgets,
        fields => [qw(user_id json_widgets_settings)],
        filter => ['json_widgets_settings', 'LIKE', \'%"all_payments"%']
      )->join(
        table   => $app->partner_db->users,
        fields  => [],
        join_on => ['id' => '=' => {user_id => $app->partner_db->widgets}]
      )->join(
        table   => $app->partner_db->user_role,
        fields  => [],
        filter  => {role_id => [qw(2 15 17 38 39)]},
        join_on => ['user_id' => '=' => {id => $app->partner_db->users}]
      );

    my $widgets = $query->get_all();
    say 'Found ', scalar @$widgets;

    foreach my $widget (@$widgets) {
        say $widget->{'user_id'} . ' old value: ' . $widget->{'json_widgets_settings'} unless $dry_run;

        my $new_widgets =
          [grep {$_->{'type'} ne 'statistics' || $_->{'settings'}{'report_id'} ne 'all_payments'}
              @{from_json($widget->{'json_widgets_settings'})}];

        eq_or_diff(from_json($widget->{'json_widgets_settings'}), $new_widgets, 'diff', {Sortkeys => 1}) if $dry_run;

        $app->partner_db->widgets->edit($widget->{'user_id'}, {json_widgets_settings => to_json($new_widgets)})
          unless $dry_run;
    }

    say "#END\n";

    $app->post_run();
}
main();
__END__
