#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Скрипт выставляет флаг need_update на всех работающих/тестируемых ппейджах,
которых коснулись изменения выставления DSP из тикета
https://st.yandex-team.ru/PI-11351

Для работы скрипта нужно подключить продакшн базу.
Никаке другие продакшн системы подключать не нужно.

На докерной базе это отметило 25862 пейджей для переотправки и работло около 20 минут.

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
    ../../lib
);
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    my $model = 'context_on_site_campaign';

    my %multistate_bits = map { $_->[0] => 1 } @{ $app->$model->get_multistates_bits(); };

    my $filter = '(working or testing) and not need_update';

    if ($multistate_bits{protected}) {
        $filter .= ' and not protected'
    }

    if ($multistate_bits{read_only}) {
        $filter .= ' and not read_only'
    }

    my $data = $app->$model->get_all(
        filter => {
            multistate => $filter,
        },
    );

    my %page_ids = map { $_->{campaign_id} => 1} @{$app->partner_db->_get_all(
        'select distinct campaign_id from context_on_site_dsps where dsp_id = 2563162',
    )};

    my $data_to_update = [];

    foreach my $el (@$data) {
        # формат данных:
        #{
        #    domain_id => 3,
        #    id => 1,
        #    owner_id => 356502796,
        #    page_id => 41443,
        #}

        if ($page_ids{$el->{page_id}}) {
            push @$data_to_update, $el;
        }
    }

    my $all_count = scalar(@$data_to_update);
    warn 'Number of Page IDs to set flag need_update: ' . $all_count . "\n";

    my $i = 0;
    foreach my $el (sort {$a->{page_id} <=> $b->{page_id}} @$data_to_update) {
        $app->$model->do_action($el, 'set_need_update');
        $i++;
        warn "making action 'set_need_update' on Page ID $el->{page_id} ($i/$all_count)\n";
    }

    $app->post_run();
    say "#END";
}
main();
__END__
