#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Test::Differences;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_option('cur_user' => {id => 0});
    my $tmp_rights = $app->add_all_tmp_rights();

    # Апдейтим две таблицы по общему принципу
    my $models = [
        {
            name  => 'statistics_reports',
            field => 'query',
        },
        {
            name  => 'stat_report_params_digest',
            field => 'params',
        },
    ];

    for my $model (@$models) {
        my ($name, $field) = @{$model}{qw(name field)};

        my @reports = @{$app->partner_db->$name->get_all(fields => ['id', $field],)};

        for my $report (@reports) {
            print 'Report ' . $report->{'id'} . ' ' . $name;

            my $r0      = from_json($report->{$field});
            my $r       = clone($r0);
            my $changed = convert_report($report->{'id'}, $r);

            if ($changed) {
                print " - changed\n";
                #eq_or_diff($r0, $r, undef, {Sortkeys => 1});

                my $json = to_json($r);
                print "json_before ($field): " . $report->{$field} . "\njson_after ($field): " . $json . "\n\n";
                $app->partner_db->$name->edit($report->{'id'}, {$field => $json},);
            } else {
                print " - ok\n";
            }
        }
    }

    $app->post_run();
    say "#END";
}

sub convert_report {
    my ($id, $report) = @_;

    my $is_changed = 0;

    if (ref($report->{tableViewModelData}) eq 'HASH') {
        $report->{tableViewModelData}->{sortBy} =~ s/_w_nds$/_wo_nds/;
    }

    # Обрабатываем chartLevel и tableLevel
    for my $view_level_name (qw(chartLevel tableLevel)) {
        # chartLevel и tableLevel в свою очередь являются массивами
        # два элемента будет в случае сравнения двух периодов
        # поэтому еще один цикл
        for my $view_level_element (@{$report->{$view_level_name}}) {

            # смотрим на fields, если есть _wo_nds и _w_nds, то второй удаляем
            # если есть только _w_nds - меняем на _wo_nds

            if (ref($view_level_element->{fields}) eq 'ARRAY') {

                my $s;
                my %have_w_nds =
                  map {($s = $_) =~ s/_w_nds$//; ($s => 1)} grep {/_w_nds$/} @{$view_level_element->{fields}};
                my %have_wo_nds =
                  map {($s = $_) =~ s/_wo_nds$//; ($s => 1)} grep {/_wo_nds$/} @{$view_level_element->{fields}};

                foreach my $key (keys %have_w_nds) {
                    if ($have_wo_nds{$key}) {
                        # есть _wo_nds - просто удаляем
                        $view_level_element->{fields} = [grep {$_ ne $key . '_w_nds'} @{$view_level_element->{fields}}];
                    } else {
                        # нет _wo_nds - меняем
                        foreach my $name (@{$view_level_element->{fields}}) {
                            if ($name eq $key . '_w_nds') {
                                $name = $key . '_wo_nds';
                            }
                        }
                    }

                    $is_changed = 1;
                }
            }

            if (ref($view_level_element->{order_by}) eq 'ARRAY') {

                my $s;
                my %have_w_nds =
                  map {($s = $_) =~ s/_w_nds$//; ($s => 1)}
                  grep {/_w_nds$/} map {$_->{field}} @{$view_level_element->{order_by}};
                my %have_wo_nds =
                  map {($s = $_) =~ s/_wo_nds$//; ($s => 1)}
                  grep {/_wo_nds$/} map {$_->{field}} @{$view_level_element->{order_by}};

                foreach my $key (keys %have_w_nds) {
                    if ($have_wo_nds{$key}) {
                        # есть _wo_nds - просто удаляем
                        $view_level_element->{order_by} =
                          [grep {$_->{field} ne $key . '_w_nds'} @{$view_level_element->{order_by}}];
                    } else {
                        # нет _wo_nds - меняем
                        foreach my $name (@{$view_level_element->{order_by}}) {
                            if ($name->{field} eq $key . '_w_nds') {
                                $name->{field} = $key . '_wo_nds';
                            }
                        }
                    }

                    $is_changed = 1;
                }
            }
        }
    }

    return $is_changed;
}

main();
__END__
