#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

my $SELLER_ID  = 17298340;
my $DSP_BLOCKS = [
    qw(
      240x400
      240x600
      300x250
      300x300
      300x500
      300x600
      320x100
      320x480
      320x50
      336x280
      400x240
      480x320
      728x90
      970x250
      1000x120
      )
];

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    say "FIX SELLER";

    my $seller =
      $app->partner_db->ssp_seller->get($SELLER_ID, fields => [qw(tmpl_ssp_mobile_app tmpl_ssp_context_rtb)]);

    foreach my $field (qw(tmpl_ssp_mobile_app tmpl_ssp_context_rtb)) {
        my $tmpl = from_json($seller->{$field});

        say "$field - old value: " . to_json($tmpl);

        my %cur_values = map {$_ => TRUE} @{$tmpl->{'dsp_blocks'}};

        $tmpl->{'dsp_blocks'} = [@{$tmpl->{'dsp_blocks'}}, grep {!$cur_values{$_}} @$DSP_BLOCKS];

        $seller->{$field} = to_json($tmpl, canonical => TRUE);
    }

    $app->partner_db->ssp_seller->edit($SELLER_ID, $seller);

    say "FIX PAGES...";

    my @page_ids = ();
    foreach my $table (qw(ssp_mobile_app ssp_context_rtb)) {
        say "FIX $table...";

        my $pages =
          $app->partner_db->$table->get_all(fields => [qw(id page_id dsp_blocks)], filter => {seller_id => $SELLER_ID});

        foreach my $page (@$pages) {
            say "$table ($page->{'id'}) - old value: " . $page->{'dsp_blocks'};

            my $dsp_blocks = from_json($page->{'dsp_blocks'});

            my %cur_values = map {$_ => TRUE} @$dsp_blocks;

            $app->partner_db->$table->edit($page,
                {dsp_blocks => to_json([@$dsp_blocks, grep {!$cur_values{$_}} @$DSP_BLOCKS])});

            if (defined($page->{'page_id'})) {
                push(@page_ids, $page->{'page_id'});
            }
        }
    }

    my $file_name = 'PI-11039_sizes_for_google';

    my $file_count = @page_ids / 5 + 1;

    my $count = 1;
    while (my @update_page_ids = splice(@page_ids, 0, $file_count)) {
        writefile($file_name . "_$count", join("\n", @update_page_ids));

        $count++;
    }

    say "perl bin/resend_to_bk.pl --file_path=... 2>&1 | tee resend_to_bk.log";

    $app->post_run();
    say "#END";
}
main();
__END__
