#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    Нужно подключить прод базу

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {TRUE};
    }

    my @is_protected            = ();
    my @can_not_set_need_update = ();
    foreach my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $query = $app->partner_db->query->select(
            table  => $app->partner_db->$model,
            fields => ['campaign_id'],
            filter => {multistate => $app->$model->get_multistates_by_filter('working'), id => $TECHNICAL_RTB_BLOCK_ID}
        );

        $query->distinct(TRUE);

        my %page_ids = ();
        foreach (@{$query->get_all}) {
            $page_ids{$_->{'campaign_id'}} = TRUE;
        }

        my $page_model = $app->$model->get_campaign_model_name();

        my $pages =
          $app->$page_model->get_all(fields => [qw(id page_id multistate)], filter => {page_id => [keys(%page_ids)]});

        foreach my $page (@$pages) {
            if ($app->$page_model->check_action($page, 'set_need_update')) {
                $app->$page_model->do_action($page->{'id'}, 'set_need_update');
            } elsif ($app->$page_model->check_multistate_flag($page->{'multistate'}, 'protected')) {
                push(@is_protected, $page->{'page_id'});
            } else {
                push(@can_not_set_need_update, $page->{'page_id'});
            }
        }
    }

    writefile('PI-11346_media_for_100500_protected', join("\n", @is_protected));

    writefile('PI-11346_media_for_100500_can_not_set_need_update', join("\n", @can_not_set_need_update));

    say "#END\n";

    $app->post_run();
}
main();
__END__
