#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use Test::More;
use Test::Differences;

# global vars

my $DICT = {
    mobile_app              => {context_page_id => 'page_id'},
    mobile_app_rtb          => {context_page_id => 'page_id'},
    internal_mobile_app     => {id              => 'page_id'},
    internal_mobile_app_rtb => {application_id  => 'page_id'},
};

# subs

# main
sub main {

    my $is_dry_run = @ARGV && $ARGV[0] eq '--dry_run' ? 1 : 0;

    my $app = Application->new();
    $app->pre_run();

    $app->set_option('cur_user' => {id => 0});
    my $tmp_rights = $app->add_all_tmp_rights();

    # Апдейтим две таблицы по общему принципу
    my $models = [
        {
            name  => 'statistics_reports',
            field => 'query',
        },
        {
            name  => 'stat_report_params_digest',
            field => 'params',
        },
    ];

    for my $model (@$models) {
        my ($name, $field) = @{$model}{qw(name field)};

        printf qq[Start process table "%s"\n], $name;

        my @reports = @{$app->partner_db->$name->get_all(fields => ['id', $field],)};
        printf qq[%d records to process\n], scalar(@reports);

        my $count                = 0;
        my $changed_digest_count = 0;
        for my $report (@reports) {
            my $r0      = from_json($report->{$field});
            my $r       = clone($r0);
            my $changed = convert_report($report->{'id'}, $r);

            if ($changed) {
                printf("  Report %s - changed\n", $report->{'id'});
                say "    Old json: ", $report->{$field} unless $is_dry_run;

                $app->partner_db->$name->edit($report->{'id'}, {$field => to_json($r)},) unless $is_dry_run;

                $changed_digest_count++ if $name eq 'stat_report_params_digest';

                # Смотрим только в statistics_reports потому что во второй таблице в 20 раз больше строк и получим гигабайтный лог который невозможно простотреть
                eq_or_diff($r0, $r, 'diff', {Sortkeys => 1, context => 0})
                  if $is_dry_run && ($name eq 'statistics_reports' || $changed_digest_count < 100);

            } else {
                printf(qq[  %d processed \n], $count) if $count && $count % 5_000 == 0;
            }

            $count++;
        }
    }

    $app->post_run();
    say "#END";
}

sub convert_report {
    my ($id, $report) = @_;

    my $is_changed = 0;

    # Обрабатываем chartLevel и tableLevel
    for my $view_level_name (qw(chartLevel tableLevel)) {
        next unless defined($report->{$view_level_name});
        # chartLevel и tableLevel в свою очередь являются массивами
        # два элемента будет в случае сравнения двух периодов
        # поэтому еще один цикл
        for my $view_level_element (@{$report->{$view_level_name}}) {

            # Не нашел случаев, когда левелов может быть != 1, но на всякий случай вставил ассерт
            my $number_of_levels = @{$view_level_element->{levels}};
            die "Report $id $view_level_name has $number_of_levels levels" if $number_of_levels != 1;

            my $level    = $view_level_element->{'levels'}[0];
            my $level_id = $level->{'id'};

            next unless $DICT->{$level_id};

            if (defined($view_level_element->{'entity_fields'})) {
                my @new_fields = ();
                foreach my $field_name (@{$view_level_element->{'entity_fields'}}) {
                    if (exists($DICT->{$level_id}{$field_name})) {
                        $is_changed = 1;

                        $field_name = $DICT->{$level_id}{$field_name};
                    }

                    push(@new_fields, $field_name);
                }

                $view_level_element->{'entity_fields'} = \@new_fields;
            }

            if (defined($level->{'filter'})) {
                if (   ref($level->{'filter'}) eq 'ARRAY'
                    && $level->{'filter'}[0] eq 'AND'
                    && ref($level->{'filter'}[1]) eq 'ARRAY')
                {

                    my @new_filter = ();
                    foreach my $filter (@{$level->{'filter'}[1]}) {
                        if (ref($filter) eq 'ARRAY') {
                            if (exists($DICT->{$level_id}{$filter->[0]})) {
                                $is_changed = 1;

                                $filter->[0] = $DICT->{$level_id}{$filter->[0]};
                            }

                            push(@new_filter, $filter);
                        } else {
                            throw sprintf('Unexpected part of filter %s', to_json($filter));
                        }
                    }

                    $level->{'filter'} = ['AND', \@new_filter];
                } elsif (ref($level->{'filter'}) ne '') {
                    throw sprintf('Unexpected filter %s', to_json($level->{'filter'}));
                }
            }

            if (defined($view_level_element->{'order_by'})) {
                my @new_order_by = ();

                foreach my $row (@{$view_level_element->{'order_by'}}) {
                    if (exists($DICT->{$level_id}{$row->{'field'}})) {
                        $is_changed = 1;

                        $row->{'field'} = $DICT->{$level_id}{$row->{'field'}};
                    }

                    push(@new_order_by, $row);
                }

                $view_level_element->{'order_by'} = \@new_order_by;
            }

            if (exists($report->{'tableViewModelData'})) {
                # Переименовываем сортировочку, если нужно
                my $table_data = $report->{'tableViewModelData'};
                if (   defined($table_data)
                    && defined($table_data->{'sortBy'})
                    && exists($DICT->{$level_id}{$table_data->{'sortBy'}}))
                {
                    $is_changed = 1;

                    $table_data->{'sortBy'} = $DICT->{$level_id}{$table_data->{'sortBy'}};
                }
            }
        }
    }

    return $is_changed;
}

main();
__END__
