#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Test::Differences;

# global vars

my $DATA =
  [{table => 'statistics_reports', field => 'query'}, {table => 'stat_report_params_digest', field => 'params'},];

# subs

# main
sub main {
    my $dry_run = $ARGV[0] && $ARGV[0] eq '--dry_run';

    my $app = Application->new();
    $app->pre_run();

    foreach my $data (@$DATA) {
        my ($table, $field) = @$data{qw(table field)};

        my $reports = $app->partner_db->$table->get_all(
            fields => ['id', $field],
            filter => $table eq 'statistics_reports'
            ? ['level', '=', \'advnet_on_site']
            : [$field, 'LIKE', \'%"advnet_on_site"%']
        );

        foreach my $report (@$reports) {
            print "Report " . $report->{'id'};

            my $query     = from_json($report->{$field});
            my $new_query = clone($query);

            my $changed = change_filter($new_query);

            if ($changed) {
                if ($dry_run) {
                    print " - ";
                    eq_or_diff($query, $new_query, 'diff', {Sortkeys => 1, context => 1});
                } else {
                    say " - changed. Old value: " . $report->{$field};
                    $app->partner_db->$table->edit($report->{'id'}, {$field => to_json($new_query)});
                }
            } else {
                say " - ok";
            }
        }
    }

    say '#END';
}

sub change_filter {
    my ($query) = @_;

    #    $query = {
    #        'chartLevel' => [
    #            #settings
    #            {
    #                'dimension_fields' => ...,
    #                'dimension_filter' => ...,
    #                'entity_fields'    => ...,
    #                'fields'           => ...,
    #                'levels'           => [
    #                    {
    #                        'filter' => ['AND', [['login', 'MATCH', ['user', 'MATCH', ['login', 'IN', ['vk-rsya']]]]]],
    #                        'id' => 'advnet_on_site'
    #                    }
    #                ],
    #                'order_by' => ...,
    #                'period'   => '90days',
    #                'top_keys' => 3,
    #                'total'    => 0,
    #                'vat'      => -1
    #            }
    #        ],
    #        'tableLevel'         => [<settings>],
    #        'tableViewModelData' => ...,
    #    };

    my $changed = FALSE;

    foreach my $view (qw(chartLevel tableLevel)) {
        next unless defined($query->{$view});

        foreach my $settings (@{$query->{$view}}) {
            foreach my $level (@{$settings->{'levels'}}) {
                next if $level->{'id'} ne 'advnet_on_site' || !defined($level->{'filter'});

                if ($settings->{'entity_fields'}) {
                    my @entity_fields = ();
                    foreach my $field (@{$settings->{'entity_fields'}}) {
                        if ($field eq 'id') {
                            $changed = TRUE;

                            $field = 'domain_id';
                        }

                        push(@entity_fields, $field);
                    }

                    $settings->{'entity_fields'} = \@entity_fields;
                }

                if ($settings->{'order_by'}) {
                    my @order_by = ();
                    foreach my $desc (@{$settings->{'order_by'}}) {
                        if ($desc->{'field'} eq 'id') {
                            $changed = TRUE;

                            $desc->{'field'} = 'domain_id';
                        }

                        push(@order_by, $desc);
                    }

                    $settings->{'order_by'} = \@order_by;
                }

                my $filters = $level->{'filter'};

                if (ref($filters) eq 'ARRAY' && $filters->[0] eq 'AND') {
                    foreach my $filter (@{$filters->[1]}) {
                        if (   $filter->[0] eq 'login'
                            && $filter->[1]    eq 'MATCH'
                            && $filter->[2][0] eq 'user'
                            && $filter->[2][1] eq 'MATCH')
                        {
                            $changed = TRUE;
                            $filter = ['users', 'MATCH', $filter->[2][2]];
                        } elsif ($filter->[0] eq 'id') {
                            $changed = TRUE;
                            $filter->[0] = 'domain_id';
                        } elsif ($filter->[0] eq 'multistate' || $filter->[0] eq 'is_graysite') {
                            $changed = TRUE;
                            $filter = ['domains', 'MATCH', $filter];
                        }
                    }
                } else {
                    throw sprintf('Unknown filter: %s', Dumper($filters));
                }

                my $table_data = $query->{'tableViewModelData'};
                if (   defined($table_data)
                    && defined($table_data->{'sortBy'})
                    && $table_data->{'sortBy'} eq 'id')
                {
                    $changed = TRUE;
                    $table_data->{'sortBy'} = 'domain_id';
                }
            }
        }
    }

    return $changed;
}

main();
__END__
