#!/usr/bin/perl

use lib '../../lib';
use lib './lib';

use qbit;
use Application;

=head1 DESCRIPTION
    Нужно подключить прод базу

    Понимает параметры:
    --dry_run - только вывод id, ничего не меняет
    --page_id=123 - только обработка page с id 123
    --model=abc_on_site - только обработка указанной модели
=cut

main();

sub main {
    my ($dry_run, $page_id, $pmodel) = _get_args();

    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    for my $model (qw(context_on_site_campaign search_on_site_campaign)) {

        next if $pmodel and $pmodel ne $model;

        my $page_field_name = eval {$app->$model->get_page_id_field_name()};

        my $pages = $app->$model->get_all(
            fields => [qw(id multistate), $page_field_name],
            filter => {multistate => 'blocked and not deleted', ($page_id ? ($page_field_name => $page_id) : ())}
        );

        print scalar(@$pages) . " $model pages to archive found\n";
        print "page_ids to process:\n" . join(",", grep {defined $_} map {$_->{page_id}} @$pages) . "\n";

        my $cnt = 0;
        foreach my $page (@$pages) {
            print ""
              . ($dry_run ? "will " : "")
              . "delete $model $page_field_name="
              . ($page->{$page_field_name} || 'NULL')
              . " (id=$page->{id})\n";
            unless ($dry_run) {
                $app->$model->do_action($page, 'delete');
            }
        }
        print "\ndone $model\n";
    }

    $app->post_run();

    print "#END\n";
}

sub _get_args {
    my $dry_run = grep {$_ =~ /--dry_run/} @ARGV;
    print "dry_run mode\n" if $dry_run;

    my ($page_id) = grep {$_ =~ /^--page_id=\d+\z/} @ARGV;
    if ($page_id) {
        $page_id =~ s/^--page_id=//;
        print "looking for page_id=$page_id\n";
    }
    my ($pmodel) = grep {$_ =~ /^--model=.+/} @ARGV;
    if ($pmodel) {
        $pmodel =~ s/^--model=//;
        print "looking for model $pmodel\n";
    }
    return ($dry_run, $page_id, $pmodel);
}
