#!/usr/bin/perl

use lib '../../lib';

use qbit;
use Application;

=head1 DESCRIPTION

    Параметры
    --dry_run - ничего не сохранять
    --page_id=123 - искать только page_id=123
=cut

main();

sub main {
    my $dry_run = grep {$_ =~ /--dry_run/} @ARGV;
    print "dry_run mode\n" if $dry_run;

    my ($page_id) = grep {$_ =~ /^--page_id=\d+\z/} @ARGV;
    if ($page_id) {
        $page_id =~ s/^--page_id=//;
        print "looking for id=$page_id\n";
    }

    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    for my $model (qw(context_on_site_campaign search_on_site_campaign)) {
        my $pages = $app->$model->get_all(
            fields => [qw(id page_id domain caption)],
            filter => {caption => '', ($page_id ? (id => $page_id) : ())}
        );

        # хачим граф, потому что иначе не все площадки получится отредактировать

        my $graph = $app->$model->get_multistates_graph_definition;
        my ($ed) = grep {$_->{action} eq 'edit'} @{$graph->{multistate_actions}};
        $ed->{from} = '__EMPTY__ or not __EMPTY__';
        my ($nu) = grep {$_->{action} eq 'set_need_update'} @{$graph->{multistate_actions}};
        $nu->{from} = '__EMPTY__ or not __EMPTY__';
        $app->$model->multistates_graph($graph);

        print scalar(@$pages) . " $model pages to edit found\n";

        foreach my $page (@$pages) {
            print "id $page->{id} page_id $page->{page_id} domain $page->{domain}\n";

            $app->$model->do_action($page, 'edit', caption => $page->{domain}) unless $dry_run;

        }
    }
    $app->post_run();

    print "#END\n";
}
