#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use File::Slurp;
use File::Temp qw(tempfile);

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my @tmpls = qw(tmpl_ssp_context_rtb tmpl_ssp_mobile_app tmpl_ssp_video_app);

    my $sellers = $app->partner_db->ssp_seller->get_all(fields => ['id', @tmpls]);

    for my $seller (@$sellers) {
        say "SELLER ID $seller->{id} START";
        for my $tmpl_name (@tmpls) {
            next unless $seller->{$tmpl_name};
            say "FIXING $tmpl_name";
            my $tmpl_data = from_json($seller->{$tmpl_name});

            delete $tmpl_data->{context};

            $seller->{$tmpl_name} = to_json($tmpl_data, canonical => 1);
        }
        $app->partner_db->ssp_seller->edit($seller->{id}, $seller);
        say "SELLER ID $seller->{id} DONE";
    }
}

main();
