#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для исправления настройки allow_multiple_dsp_ads в adfox блоках video_an_site_instream.
У Adfox блоков allow_multiple_ads должен быть выключен (равен нулю).
Требует подключения ПРОД базы.

=cut

use lib::abs qw(../../lib/);

use feature say;

use qbit;
use Application;

sub main {
    my %args = map {$_ => 1} @ARGV;
    my $dry_run = $args{'--dry-run'};

    my $app = Application->new();

    $app->pre_run();

    $app->set_option('cur_user' => {id => 0});

    my $tmp_rights = $app->add_all_tmp_rights();

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $adfox_blocks = $app->video_an_site_instream->get_all(
        fields => [qw(id page_id adfox_block allow_multiple_dsp_ads)],
        filter => {adfox_block => 1}
    );
    foreach my $block (@$adfox_blocks) {
        if ($block->{'allow_multiple_dsp_ads'}) {
            say to_json($block, canonical => 1);
            unless ($dry_run) {
                $app->partner_db->video_an_site_instream->edit($block, {allow_multiple_dsp_ads => 0});
                $app->video_an_site_instream->do_action($block, 'set_need_update');
            }
        }
    }

    say '#END';
}

main();
