#!/usr/bin/perl

use feature 'say';
use lib::abs qw( ../../lib );

use qbit;
use Application;
use Utils::Logger qw( INFO INFOF );

my $format_max_banners = {
    '160x600'  => 2,
    '240x400'  => 2,
    '300x300'  => 2,
    '300x500'  => 2,
    '300x600'  => 2,
    '400x240'  => 2,
    '480x320'  => 2,
    '970x250'  => 4,
    '970x90'   => 2,
    '1000x120' => 3,
};

####
_run();
#####

sub _run {

    my $app = _get_app();

    my @model_accessors = grep {blessed($app->{$_}) && $app->$_->can('direct_block_types')} keys(%$app);

    foreach my $accessor (sort @model_accessors) {

        INFOF 'Model "%s":', $accessor;

        my $model = $app->$accessor;

        my $db_table_name = $model->db_table_name();
        my $fields = {map {$_->{'name'} => 1} @{$app->partner_db->$db_table_name->fields()}};

        my $format_field_name = $fields->{'direct_block'} ? 'direct_block' : 'type';

        my $count_affected = 0;
        foreach my $format (sort keys %$format_max_banners) {

            my $filter = [
                'AND',
                [
                    [$format_field_name, '=', \$format],
                    (
                        $fields->{is_custom_format_direct}
                        ? (['is_custom_format_direct', '=', \0])
                        : ()
                    ),
                    ['OR', [['limit', 'is', \undef], ['limit', '<>', \$format_max_banners->{$format}]]]

                ]
            ];

            my $found = $app->partner_db->$db_table_name->get_all(
                filter => $filter,
                fields => ['id'],
            );

            if (@$found) {
                INFOF '  format "%s" - rows to update %s', $format, scalar(@$found);

                $app->partner_db->$db_table_name->edit($app->partner_db->filter($filter),
                    {limit => $format_max_banners->{$format}});
                $count_affected += @$found;

                INFO '    update successfully';
            }
        }

        INFOF '  rows updated %s', $count_affected;
    }

    1;
}

sub _get_app {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    return $app;
}
