#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

use lib::abs qw(../../lib/);
use feature say;
use qbit;
use Application;
use File::Temp qw(tempfile);

# Файл миграции сделан на основе
# git checkout 2.18.513 -- migrations/after_release/PI-9665_view_smart.pl
# с оставлением в списке только rambler-p и инвертированием условия применения

my $APP;

main();

sub main {

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    $APP = Application->new();

    $APP->pre_run();

    resend_apps();

    $APP->post_run();
}

sub resend_apps {
    my $pages = $APP->partner_db->all_pages_view->get_all(
        fields => [qw(page_id)],
        filter => [
            'AND',
            [
                ['page_id',  'IS NOT', \undef],
                ['owner_id', '=',      \120143188],    # rambler-p
            ]
        ]
    );

    my @page_ids = map {$_->{'page_id'}} @$pages;

    my %page_ids = ();

    foreach my $accessor (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $direct_blocks =
          [map {$_->{'id'}} grep {$_->{'id'} =~ /^\d+x\d+$/} @{$APP->$accessor->direct_block_types()}];
        my $page_id_name = $APP->$accessor->get_page_id_field_name();
        my $query        = $APP->partner_db->query->select(
            table  => $APP->partner_db->$accessor,
            fields => [$page_id_name],
            filter => [
                'AND',
                [
                    ['multistate',    'IN', \$APP->$accessor->get_multistates_by_filter('not deleted')],
                    ['media_blocked', '=',  \1],
                    ['direct_block',  'IN', \$direct_blocks],
                    [$page_id_name,   'IN', \\@page_ids]
                ]
            ]
        );

        $page_ids{$_->{'campaign_id'}} = 1 foreach @{$query->get_all()};
    }

    my ($page_ids_fh, $page_ids_file_name) = tempfile('PI_13093_remove_ignore_XXXXXX', DIR => './');
    my (undef, $log_file_name) = tempfile('PI_13093_remove_ignore_log_XXXXXX', OPEN => 0, DIR => './');

    $page_ids_fh->print(join("\n", sort keys(%page_ids)));
    close($page_ids_fh);

    say "resend_to_bk.pl input file: $page_ids_file_name";
    say "resend_to_bk.pl log file: $log_file_name";

    my $system_string = "perl bin/resend_to_bk.pl --file_path=$page_ids_file_name 1>>$log_file_name 2>>$log_file_name";

    say "Starting system('$system_string')";

    system($system_string);

    say 'END';
}
