#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;
use Utils::Logger qw(INFO);

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $protected = $app->partner_db->mobile_app_settings->get_all(
        fields => [qw(context_page_id)],
        filter => [\256 => '=' => ['&' => ['multistate', \256]]]
    );

    my @protected_pages = map {$_->{context_page_id}} @$protected;

    my $res = $app->partner_db->mobile_app_rtb->get_all(
        fields => [qw(id context_page_id show_video)],
        filter => [
            AND => [
                ['block_type' => '=' => \'banner'],
                [
                    OR => [
                        ['direct_block' => 'IN' => \['300x300', '300x250']],
                        [
                            AND => [
                                ['direct_block'    => 'IN' => \['horizontal', 'adaptive']],
                                ['adaptive_height' => '>=' => \250]
                            ],
                        ]
                    ]
                ],
                ['media_block' => 'IN' => \['300x300', '300x250']],
                [\0                => '='      => ['&' => ['multistate', \1]]],
                ['context_page_id' => 'NOT IN' => \\@protected_pages]
            ]
        ]
    );

    my $cntr = 0;
    INFO "Setting show_video for RTB blocks:";
    foreach my $block (@$res) {
        my $dsps = $app->partner_db->mobile_app_rtb_dsp_blocks->get_all(
            fields => [qw(block_id context_page_id)],
            filter => [
                AND => [
                    ['block_id'        => '='      => \$block->{id}],
                    ['context_page_id' => '='      => \$block->{context_page_id}],
                    ['type'            => 'NOT IN' => \['300x300', '300x250']],
                ]
            ]
        );
        next if scalar @$dsps;

        my $block_public_id = $app->mobile_app_rtb->public_id_prefix . $block->{context_page_id} . '-' . $block->{id};
        say "#" . ++$cntr . " " . $block_public_id;
        $app->mobile_app_rtb->do_action($block_public_id, 'edit', show_video => 1);
    }

    #INTERNAM_MONBILE_APP_RTB
    $protected = $app->partner_db->internal_mobile_app->get_all(
        fields => [qw(id)],
        filter => [\32 => '=' => ['&' => ['multistate', \32]]]
    );

    @protected_pages = map {$_->{id}} @$protected;

    $res = $app->partner_db->internal_mobile_app_rtb->get_all(
        fields => [qw(id application_id show_video)],
        filter => [
            AND => [
                ['block_type' => '=' => \'banner'],
                [
                    OR => [
                        ['direct_block' => 'IN' => \['300x300', '300x250']],
                        [
                            AND => [
                                ['direct_block'    => 'IN' => \['horizontal', 'adaptive']],
                                ['adaptive_height' => '>=' => \250]
                            ],
                        ]
                    ]
                ],
                ['is_custom_bk_data' => '='  => \0],
                ['media_block'       => 'IN' => \['300x300', '300x250']],
                [\0               => '='      => ['&' => ['multistate', \1]]],
                ['application_id' => 'NOT IN' => \\@protected_pages]
            ]
        ]
    );

    $cntr = 0;
    INFO "Setting show_video for internal RTB blocks:";
    foreach my $block (@$res) {
        my $dsps = $app->partner_db->internal_mobile_app_rtb_dsp_blocks->get_all(
            fields => [qw(block_id application_id)],
            filter => [
                AND => [
                    ['block_id'       => '='      => \$block->{id}],
                    ['application_id' => '='      => \$block->{application_id}],
                    ['type'           => 'NOT IN' => \['300x300', '300x250']],
                ]
            ]
        );
        next if scalar @$dsps;

        my $block_public_id =
          $app->internal_mobile_app_rtb->public_id_prefix . $block->{application_id} . '-' . $block->{id};
        say "#" . ++$cntr . " " . $block_public_id;
        $app->internal_mobile_app_rtb->do_action($block_public_id, 'edit', show_video => 1);
    }

    INFO '#END';
}

main();
