#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Скрипт выставляет флаг need_update на всех работающих/тестируемых
видео-пейджах, кроме protected и тех, у которых уже стоит флаг
need_update. Для отправки нового парметра video-motion из тикета
https://st.yandex-team.ru/PI-12866

Для работы скрипта нужно подключить продакшн базу.

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

my $page_model = 'video_an_site';

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my %multistate_bits = map {$_->[0] => 1} @{$app->$page_model->get_multistates_bits();};

    my $filter = '(working or testing) and not need_update';

    if ($multistate_bits{protected}) {
        $filter .= ' and not protected';
    }

    if ($multistate_bits{read_only}) {
        $filter .= ' and not read_only';
    }

    my $data = $app->$page_model->get_all(
        fields => [qw(id page_id multistate cur_user_is_read_assistant)],
        filter => {multistate => $filter,}
    );

    my $all_count = scalar(@$data);
    say 'Number of Page IDs to set flag need_update: ' . $all_count . "\n";

    my $i = 0;
    foreach my $el (sort {$a->{page_id} <=> $b->{page_id}} @$data) {
        $i++;
        try {
            $app->$page_model->do_action($el, 'set_need_update');
            say "making action 'set_need_update' on Page ID $el->{page_id} ($i/$all_count)\n";
        }
        catch {
            my ($exception) = @_;
            say 'ERROR: ' . $exception->message;
        }
    }

    $app->post_run();
    say "#END";
}

main();
__END__
