#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    меняет владельца указанных pages
    нужно подключить прод базу

=head1 USAGE

    script.pl --view
    script.pl --commit

=head1 OPTIONS

    commit - сделать изменения
    show   - показать текст запроса
    view   - показать данные которые будут изменены

=cut

use lib::abs qw( ../../lib );

use Pod::Usage;
use Getopt::Long qw();
use Data::Dumper;

use qbit;
use Application;

my $login = 'mediaservices-team';
my $COMMIT;
my $SHOW;
my $VIEW;
my $app;

sub main {

    _get_args();
    $app = _get_app();

    my $user    = get_user($login);
    my $user_id = $user->{id};
    my $data    = get_data();
    my $pages   = find_pages($data);

    if ($VIEW) {
        for my $accessor (keys %$pages) {
            my $model      = $app->$accessor;
            my $page_field = $model->get_page_id_field_name;
            my $list       = $model->get_all(
                filter => [$page_field => 'IN' => $pages->{$accessor}],
                fields => [$page_field, 'owner_id'],
            );
            for my $page (@$list) {
                warn "$accessor.$page->{$page_field}: $page->{owner_id}\n";
            }
        }

    } else {
        for my $accessor (keys %$pages) {
            die "bad accessor: '$accessor'\n" unless $accessor eq 'video_an_site';
            my $model      = $app->$accessor;
            my $page_field = $model->get_page_id_field_name;
            my $filter     = $model->partner_db->filter([$page_field => 'IN' => \$pages->{$accessor}]);
            my $count      = $model->partner_db_table->edit($filter, {owner_id => $user_id});
            warn "$accessor: $count\n";
        }

    }
}

sub get_user {
    my ($login) = @_;

    my $user = $app->users->get_all(
        fields => ['id'],
        filter => {login => $login},
    );

    return $user->[0];
}

sub find_pages {
    my ($data) = @_;

    my $list = $app->all_pages->get_all(
        fields => ['page_id', 'model', 'domain_id'],
        filter => [page_id => IN => $data],
    );

    my %page_by_model;
    for my $row (@$list) {
        push @{$page_by_model{$row->{model}}}, $row->{page_id};
    }

    return \%page_by_model;
}

sub get_data {

    my @data;
    while (my $str = <DATA>) {
        $str =~ s/\s+//g;
        push @data, $str if $str;
    }

    return \@data;
}

sub _get_app {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    no strict 'refs';
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};

    if ($SHOW or !$COMMIT) {
        my $do = QBit::Application::Model::DB::mysql->can('_do');
        *QBit::Application::Model::DB::mysql::_do = sub {
            warn $_[1], "\n" if $SHOW;
            unless ($COMMIT) {
                return 0;
            } else {
                return $do->(@_);
            }
        };
    }

    return $app;
}

sub _get_args {

    my $help = 0;

    Getopt::Long::GetOptions(
        'view!'    => \$VIEW,
        'commit!'  => \$COMMIT,
        'show!'    => \$SHOW,
        'help|?|h' => \$help,
    ) or pod2usage(1);

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    1;
}

main();

__DATA__
147364
139316
141995
146552
146930
146931
150335
191497
191499
201963
201964
210654
28212
274574
280612
289448
289861
146925
146926
146929
139599
150336
242820
