#!/bin/bash

export YT_HOME=$HOME

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

################## Constants

YT_META_CLUSTER='markov'
YT_REPLICA_CLUSTER_1='hahn'
YT_REPLICA_CLUSTER_2='banach'

YT_PROJECT_PATH='//home/partner'

YT_TABLE_PATH="${YT_PROJECT_PATH}/action_logs"


REPLICA_ID_ClUSTER_1=$(yt get "${YT_TABLE_PATH}/@upstream_replica_id" --proxy $YT_REPLICA_CLUSTER_1 | sed 's|"||g')
REPLICA_ID_ClUSTER_2=$(yt get "${YT_TABLE_PATH}/@upstream_replica_id" --proxy $YT_REPLICA_CLUSTER_2 | sed 's|"||g')

yt alter-table-replica $REPLICA_ID_ClUSTER_1 --disable --mode async  --proxy $YT_META_CLUSTER
yt alter-table-replica $REPLICA_ID_ClUSTER_2 --disable --mode async  --proxy $YT_META_CLUSTER

# Удаляем старый action_logs, если есть
yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
yt remove $YT_TABLE_PATH --proxy $YT_META_CLUSTER      2>/dev/null || true

# Смотрим что осталось
yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_1
yt list $YT_PROJECT_PATH --proxy $YT_REPLICA_CLUSTER_2
yt list $YT_PROJECT_PATH --proxy $YT_META_CLUSTER

exit 0;
