#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    my $yndx_bessarabov_user_id = 155209804;
    $app->set_cur_user({id => $yndx_bessarabov_user_id});

    my $data = $app->partner_db->_get_all(
        'select id, context_page_id from mobile_app_settings where create_date = "0000-00-00 00:00:00"',
    );

    foreach my $el (@$data) {

        my $add_data = $app->partner_db->_get_all(
            "select dt from mobile_app_settings_action_log where elem_id = ? and action = 'add'",
            $el->{id},);

        if (@$add_data != 1) {
            die "Can't find info about adding mobile_app_settings in action_log" . Dumper($el);
        }

        say to_json({%$el, new_create_date => $add_data->[0]->{dt}}, canonical => 1);

        $app->partner_db->_do(
            'update mobile_app_settings set create_date = ? where id = ?',
            $add_data->[0]->{dt},
            $el->{id},
        );

    }

    $app->post_run();
    say "#END";
}
main();
__END__
