#!/usr/bin/perl

use lib::abs qw(
  ./lib
  );
use qbit;
use Application;

my $LINK_STAT_DEFAILT_STR = 'https://metrika.yandex.ru/add/';

sub _is_link_stat_valid($$) {
    my ($app, $link_stat) = @_;
    my $qv = QBit::Validator->new(
        data       => $link_stat,
        app        => $app->owner_site,
        'template' => $app->owner_site->get_model_fields()->{link_stat}->{need_check},
    );
    return !$qv->has_error();
}

sub main($) {
    my ($app) = @_;

    my $LIMIT  = 1000;
    my $offset = 0;

    my @fields = qw( domain_id user_id link_stat );

    my $more_records          = 1;
    my $invalid_records_count = 0;

    my @list_pk_to_update = ();

    printf("%s\t%s\t%s\n", @fields);

    while ($more_records) {

        my $owner_site_list_chunk = $app->partner_db->owner_site->get_all(
            fields   => \@fields,
            order_by => \@fields,
            limit    => $LIMIT,
            offset   => $offset,
        );

        foreach my $owner_site (@$owner_site_list_chunk) {
            unless (_is_link_stat_valid($app, $owner_site->{link_stat})) {
                printf("%d\t%d\t%s\n",
                    $owner_site->{domain_id},
                    $owner_site->{user_id},
                    $owner_site->{link_stat} || 'NULL');

                push @list_pk_to_update, [$owner_site->{domain_id}, $owner_site->{user_id}];

                $invalid_records_count++;
            }
        }

        $offset += $LIMIT;

        $more_records = ($LIMIT == scalar @$owner_site_list_chunk);

    }
    print "\nINVALID link_stat COUNT: [$invalid_records_count]\n";

    # updating
    my $updated_records_count = 0;
    while (scalar @list_pk_to_update) {
        my @list_pk_chunk = splice(@list_pk_to_update, 0, $LIMIT);
        $updated_records_count +=
          $app->partner_db->owner_site->edit(\@list_pk_chunk, {link_stat => $LINK_STAT_DEFAILT_STR});
    }
    print "\nUPDATED link_stat COUNT: [$updated_records_count]\n";
}

main(Application->new()->pre_run());
print "#END\n";
