#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    fix_ssp_application($app);

    $app->post_run();

    print "#END\n";
}

sub fix_ssp_application {
    my ($app) = @_;

    my $list_invalid_apple_id = $app->partner_db->ssp_application->get_all(
        fields => ['id', 'apple_id'],
        filter => [AND => [['store_id' => '=' => \2], ['apple_id' => 'LIKE' => \'id%'],]],
    );

    foreach my $invalid_app (@$list_invalid_apple_id) {
        printf("\n\nInvalid ssp_app id[%d] apple_id[%s]\n", $invalid_app->{id}, $invalid_app->{apple_id});
        (my $valid_apple_id = $invalid_app->{apple_id}) =~ s/\D//g;

        my $ok_app = $app->partner_db->ssp_application->get_all(
            fields => ['id', 'apple_id'],
            filter => [AND => [['id' => '!=' => \$invalid_app->{id}], ['apple_id' => '=' => \$valid_apple_id],]],
        )->[0];

        my $c = 0;
        if ($ok_app) {

            printf(" Found valid ssp_app id[%d] apple_id[%s]\n", $ok_app->{id}, $ok_app->{apple_id});

            my $invalid_app_ssp_link_mobile_app_elem_id = $app->partner_db->ssp_link_mobile_app->get_all(
                fields => ['id', 'weight', 'seller_id'],
                filter => ['application_id' => '=' => \$invalid_app->{id}]
            );

            foreach my $invalid_ssp_app_link_x (@$invalid_app_ssp_link_mobile_app_elem_id) {
                printf(" Fixing invalid ssp_app ssp_link_mobile_app id[%d]\n", $invalid_ssp_app_link_x->{id});

                my $ok_app_ssp_link_mobile_app_elem_id = $app->partner_db->ssp_link_mobile_app->get_all(
                    fields => ['id', 'weight', 'seller_id'],
                    filter => [
                        AND => [
                            ['seller_id'      => '=' => \$invalid_ssp_app_link_x->{seller_id}],
                            ['application_id' => '=' => \$ok_app->{id}],
                        ]
                    ]
                )->[0];

                if ($ok_app_ssp_link_mobile_app_elem_id) {
                    $c = $app->partner_db->ssp_link_mobile_app->edit(
                        {id => $ok_app_ssp_link_mobile_app_elem_id->{id}},
                        {
                            weight => $ok_app_ssp_link_mobile_app_elem_id->{weight}
                              // 0 + $invalid_ssp_app_link_x->{weight} // 0,
                        }
                    );
                    printf(
                        " Updated ssp_link_mobile_app[%d].weight from [%d] to [%d]\n",
                        $ok_app_ssp_link_mobile_app_elem_id->{id},
                        $ok_app_ssp_link_mobile_app_elem_id->{weight},
                        $ok_app_ssp_link_mobile_app_elem_id->{weight} + $invalid_ssp_app_link_x->{weight}
                    );

                    $c =
                      $app->partner_db->ssp_link_mobile_app_action_log->delete(
                        $app->partner_db->filter(['elem_id' => '=' => \$invalid_ssp_app_link_x->{id}]));
                    printf(" Deleted ssp_link_mobile_app_action_log.elem_id = [%d], [%s] record \n",
                        $invalid_ssp_app_link_x->{id}, $c);

                } else {
                    $c = $app->partner_db->ssp_link_mobile_app->edit({id => $invalid_ssp_app_link_x->{id}},
                        {application_id => $ok_app->{id}});
                    printf(
                        " Updated ssp_link_mobile_app[%d].application_id from [%d] to [%d]\n",
                        $invalid_ssp_app_link_x->{id},
                        $invalid_app->{id}, $ok_app->{id}
                    );
                }
            }

            # after all records with invalid app has been purged entirely from `ssp_link_mobile_app_action_log`
            $c =
              $app->partner_db->ssp_link_mobile_app->delete(
                $app->partner_db->filter(['application_id' => '=' => \$invalid_app->{id}]));
            printf(" Deleted ssp_link_mobile_app.id = [%d], [%s] record \n", $invalid_app->{id}, $c);

            $c =
              $app->partner_db->ssp_mobile_app_settings->edit(
                $app->partner_db->filter(['source_id' => '=' => \$invalid_app->{id}]),
                {'source_id' => $ok_app->{id}});
            printf(" Updated ssp_mobile_app_settings.source_id = [%d] where source_id = [%d], %s records\n",
                $ok_app->{id}, $invalid_app->{id}, $c);

            $c =
              $app->partner_db->ssp_impression_log->edit(
                $app->partner_db->filter(['application_id' => '=' => \$invalid_app->{id}]),
                {'application_id' => $ok_app->{id}});
            printf(" Updated ssp_impression_log.application_id = [%d] where application_id = [%d], %s records\n",
                $ok_app->{id}, $invalid_app->{id}, $c);

            $c = $app->partner_db->ssp_application->delete({id => $invalid_app->{id}});
            printf(" Deleted ssp_application.id = [%d], %s records\n", $invalid_app->{id}, $c);

        } else {
            $c = $app->partner_db->ssp_application->edit({id => $invalid_app->{id}}, {apple_id => $valid_apple_id});
            printf(" Updated ssp_application.id = [%d] set apple_id = [%d], %s records\n",
                $invalid_app->{id}, $valid_apple_id, $c);
        }
    }

}
