delete from statistics_reports where id='indoor_report';
delete from statistics_reports where id='indoor_block_report';
delete from statistics_reports where id='indoor_block_report_detailed';

INSERT INTO statistics_reports (`id`, `level`, `caption_ru`, `caption_en`, `multistate`, `not_show`, `query`)
VALUES (
    'indoor_report',
    'indoor',
    'Отчет по Indoor  за ${period||30days}',
    'Report on Indoor for ${period||30days}',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "partner_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "partner_wo_nds",
        "all_wo_nds",
        "indoor_block_visibility",
        "indoor_block_winrate",
        "indoor_block_cpm_partner_wo_nds",
        "indoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true
}
'), (
    'indoor_block_report',
    'indoor_block',
    'Отчет по Indoor блокам за ${period||30days} (без детализации по дням)',
    'Report on Indoor blocks for ${period||30days} (without daily details)',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds"
      ],
      "dimension_fields": [
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [
        "page_id"
      ],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds",
        "indoor_block_visibility",
        "indoor_block_winrate",
        "indoor_block_cpm_partner_wo_nds",
        "indoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [
        "page_id"
      ],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true,
  "tableViewModelData": {
    "sortBy": "page_id",
    "sortOrder": "desc"
  }
}
'), (
    'indoor_block_report_detailed',
    'indoor_block',
    'Отчет по Indoor блокам за ${period||30days} (с детализацией по дням)',
    'Report on Indoor for ${period||30days} (with daily details)',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds",
        "indoor_block_visibility",
        "indoor_block_winrate",
        "indoor_block_cpm_partner_wo_nds",
        "indoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true
}
');

