delete from statistics_reports where id='outdoor_report';
delete from statistics_reports where id='outdoor_block_report';
delete from statistics_reports where id='outdoor_block_report_detailed';

INSERT INTO statistics_reports (`id`, `level`, `caption_ru`, `caption_en`, `multistate`, `not_show`, `query`)
VALUES (
    'outdoor_report',
    'outdoor',
    'Отчет по OutDoor  за ${period||30days}',
    'Report on OutDoor for ${period||30days}',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "partner_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "partner_wo_nds",
        "all_wo_nds",
        "outdoor_block_visibility",
        "outdoor_block_winrate",
        "outdoor_block_cpm_partner_wo_nds",
        "outdoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true
}
'), (
    'outdoor_block_report',
    'outdoor_block',
    'Отчет по OutDoor блокам за ${period||30days} (без детализации по дням)',
    'Report on OutDoor blocks for ${period||30days} (without daily details)',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds"
      ],
      "dimension_fields": [
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [
        "page_id"
      ],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds",
        "outdoor_block_visibility",
        "outdoor_block_winrate",
        "outdoor_block_cpm_partner_wo_nds",
        "outdoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [
        "page_id"
      ],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true,
  "tableViewModelData": {
    "sortBy": "page_id",
    "sortOrder": "desc"
  }
}
'), (
    'outdoor_block_report_detailed',
    'outdoor_block',
    'Отчет по OutDoor блокам за ${period||30days} (с детализацией по дням)',
    'Report on OutDoor for ${period||30days} with daily details)',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": null
        }
      ],
      "top_keys": 3,
      "period": "${period||30days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds",
        "outdoor_block_visibility",
        "outdoor_block_winrate",
        "outdoor_block_cpm_partner_wo_nds",
        "outdoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": null
        }
      ],
      "order_by": [],
      "period": "${period||30days}"
    }
  ],
  "isLevelsDifferent": true
}
');

