#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

my $LOGINS = [
    qw(
      a.lundovsky
      a.vesnin
      ad.banki
      adopsximad
      adtoappcom
      adv.vertis
      aifru
      akorolkow
      alfacode.net
      appvilion
      avitortb2013
      bashregion30
      bumsun
      dexterfx
      dine4fit
      fishki.official
      gismart.marketing
      golubev.columbis
      internetmediagroup
      iprsya
      jackyxdorlina
      k.chuzhov
      lovedirect
      marisha119
      mcmdev
      mobiledimension
      mobiloids2016
      molokov.mobile
      officengsru
      pc386
      psssum
      rambler.p
      rasulismailov001
      rusmetallurgiya
      rusnovostiru
      ruyzakiy2
      sigov.ask.fm
      smi2smi2
      sport.e
      sportlist
      stefaniak.joanna
      subprogram
      thest3
      trista60tv
      tutbaikin
      vbbelous
      vladimir.anikin.private
      www.cn.ru
      )
];

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    my $user_ids = get_user_ids($app);

    my $page_block_ids = get_mobile_page_block_ids($app, $user_ids);

    fix_statistics($app, $page_block_ids);

    $app->post_run();

    print "#END\n";
}

sub get_user_ids {
    my ($app) = @_;

    my $res = $app->users->get_all(fields => [qw(id login)], filter => {login => $LOGINS});

    if (@$res != @$LOGINS) {
        my %logins = map {$_->{'login'} => TRUE} @$res;

        throw 'not found all users: ' . join(', ', grep {!$logins{$_}} map {$_ =~ s/\./-/g; $_} @$LOGINS);
    }

    return [map {$_->{'id'}} @$res];
}

sub get_mobile_page_block_ids {
    my ($app, $user_ids) = @_;

    my $pages = $app->mobile_app_settings->get_all(
        fields => [qw(page_id)],
        filter => ['AND', [{owner_id => $user_ids}, ['page_id', 'IS NOT', undef]]]
    );

    my %page_block_ids = map {$_->{'page_id'} => {}} @$pages;

    my $blocks = $app->mobile_app_rtb->get_all(
        fields => [qw(page_id id multistate)],
        filter => {page_id => [keys(%page_block_ids)]}
    );

    $page_block_ids{$_->{'page_id'}}->{$_->{'id'}} =
      $app->mobile_app_rtb->check_multistate_flag($_->{'multistate'}, 'working') ? 2 : 1
      foreach @$blocks;

    return \%page_block_ids;
}

sub get_direct_stat {
    my ($app, $page_block_ids, $date) = @_;

    no strict 'refs';
    no warnings 'redefine';
    *{'Application::Model::Statistics::Payment::AdvOnSite::Direct::_delete'}                        = sub { };
    *{'Application::Model::Statistics::Payment::AdvOnSite::ContextOnSite::Direct::_add_zero_block'} = sub { };

    my @direct_stat = ();

    *{'Application::Model::Statistics::Payment::AdvOnSite::Direct::_add_multi'} = sub {
        my ($self, $recs, %opts) = @_;

        push(@direct_stat, @$recs);
    };

    my $self = $app->statistics_advnet_context_on_site_direct();

    my $pages_stat = $self->get_pages_stat(
        from      => $date,
        to        => $date,
        callbacks => $self->_get_pages_stat_callbacks($page_block_ids)
    );

    my $balance_stat_tags = $self->get_pages_tags_stat(
        from      => $date,
        to        => $date,
        callbacks => $self->_get_pages_tags_stat_callbacks($page_block_ids, [keys(%$page_block_ids)], $pages_stat),
    );

    return @direct_stat;
}

sub get_rtb_stat {
    my ($app, $page_block_ids, $date) = @_;

    no strict 'refs';
    no warnings 'redefine';
    local *{'Application::Model::Statistics::RTB::_delete'} = sub { };

    my @rtb_stat = ();

    local *{'Application::Model::Statistics::RTB::_add_multi'} = sub {
        my ($self, $recs, %opts) = @_;

        push(@rtb_stat, @$recs);
    };

    my $self = $app->statistics_mobile_app_rtb();

    my $dsp_page_stat = $self->get_dsp_page_stat(
        from      => $date,
        to        => $date,
        callbacks => $self->_get_dsp_page_stat_callbacks($page_block_ids),
    );

    my $direct_rtb_stat = $self->get_direct_rtb_stat(
        from      => $date,
        to        => $date,
        callbacks => $self->_get_direct_rtb_stat_callbacks($page_block_ids),
    );

    $self->get_dsp_stat_with_tags(
        from => $date,
        to   => $date,
        callbacks =>
          $self->_get_dsp_stat_callbacks($page_block_ids, [keys(%$page_block_ids)], $dsp_page_stat, $direct_rtb_stat),
    );

    return @rtb_stat;
}

sub fix_statistics {
    my ($app, $page_block_ids) = @_;

    foreach my $day (25 .. 31) {    #25-31
        my $date = "2017-03-$day";
        print format_date(time, "%c", iformat => "sec") . "\nDATE: $date\n";

        my @direct_stat = get_direct_stat($app, $page_block_ids, $date);

        my %direct_stat = ();
        my %check_rows  = ();
        foreach my $row (@direct_stat) {
            push(@{$direct_stat{$row->{'campaign_id'}}}, $row);
            $check_rows{$row->{'campaign_id'}}++;
        }

        throw 'More rows than one' if grep {$check_rows{$_} > 1} keys(%check_rows);

        my @rtb_stat = get_rtb_stat($app, $page_block_ids, $date);

        my %rtb_stat_fox_fix = ();
        my %rtb_pages        = ();

        my @result = ();
        foreach my $row (@rtb_stat) {
            $rtb_pages{$row->{'context_page_id'}} = TRUE;

            if ($row->{'dsp_id'} == 1) {
                push(@{$rtb_stat_fox_fix{$row->{'context_page_id'}}}, $row);
            } else {
                push(@result, $row);
            }
        }

        my $rtb_product = $app->statistics_mobile_app_rtb;

        my @fields = qw(
          mobile_rtb_block_direct_shows
          mobile_rtb_block_direct_clicks
          all_w_nds
          all_wo_nds
          partner_w_nds
          partner_wo_nds
          mobile_rtb_all_w_nds
          mobile_rtb_all_wo_nds
          mobile_rtb_partner_w_nds
          mobile_rtb_partner_wo_nds
          );

        foreach my $page_id (keys(%direct_stat)) {
            $rtb_pages{$page_id} = TRUE;

            my $r_stat =
              create_stat_entry($rtb_product, $date, $page_id, get_working_block($page_block_ids->{$page_id}), 1);

            my $d_stat = $direct_stat{$page_id}->[0];

            $r_stat->{'mobile_rtb_block_direct_shows'}  = $d_stat->{'direct_context_shows'};
            $r_stat->{'mobile_rtb_block_direct_clicks'} = $d_stat->{'direct_context_clicks'};

            $r_stat->{'all_w_nds'}  = $d_stat->{'all_w_nds'};
            $r_stat->{'all_wo_nds'} = $d_stat->{'all_wo_nds'};

            $r_stat->{'partner_w_nds'}  = $d_stat->{'partner_w_nds'};
            $r_stat->{'partner_wo_nds'} = $d_stat->{'partner_wo_nds'};

            $r_stat->{'mobile_rtb_all_w_nds'}  = $d_stat->{'direct_context_all_w_nds'};
            $r_stat->{'mobile_rtb_all_wo_nds'} = $d_stat->{'direct_context_all_wo_nds'};

            $r_stat->{'mobile_rtb_partner_w_nds'}  = $d_stat->{'direct_context_partner_w_nds'};
            $r_stat->{'mobile_rtb_partner_wo_nds'} = $d_stat->{'direct_context_partner_wo_nds'};

            if (exists($rtb_stat_fox_fix{$page_id})) {
                my $fix_stat = $rtb_product->fix_statistics(
                    [$r_stat, @{$rtb_stat_fox_fix{$page_id}}],
                    $rtb_stat_fox_fix{$page_id},
                    fields => \@fields,
                );

                push(@result, @$fix_stat);

                delete($rtb_stat_fox_fix{$page_id});
            } else {
                push(@result, $r_stat);
            }
        }

        push(@result, @{$rtb_stat_fox_fix{$_}}) foreach keys(%rtb_stat_fox_fix);

        $rtb_product->_delete($date, [keys(%rtb_pages)]);

        $rtb_product->_add_multi(\@result);
    }
}

sub get_working_block {
    my ($blocks) = @_;

    return (grep {$blocks->{$_} == 2} keys(%$blocks))[0] // throw 'not found working block';
}

sub create_stat_entry {
    my ($self, $dt, $page_id, $block_id, $dsp_id) = @_;

    return {
        dt              => $dt,
        context_page_id => $page_id,
        block_id        => $block_id,
        dsp_id          => $dsp_id,
        currency_id     => 2,           #RUB
        map {$_ => 0} @{$self->get_table_fields_without_pk()}
    };
}
