#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION
Скрипт мигрирует тематики из tns в iab

=head1 USAGE
  migrations/before_release/PI-15696_picategories_for_all_MANUAL.pl --sql --skip_logs
  migrations/before_release/PI-15696_picategories_for_all_MANUAL.pl --commit

=head1 OPTIONS
  sql    - показать SQL запрос
  commit - внести изменения в базу
=cut

use lib qw(lib);

use qbit;
use Application;
use Utils::ScriptWrapper;

run(\&main);

sub main {
    my ($app, $opts) = @_;

    my $category_map = $app->api_yt_partner_picategory_mapping->get_picategory_articles_mapping();
    my $dict         = $category_map->{PI_TNS};

    my $case = '';
    while (my ($iab, $tns) = each %$dict) {
        $case .= sprintf("    WHEN article_sid in (%s) THEN %s\n", join(',', @$tns), $iab);
    }

    my $sql = "insert ignore into picategories (page_id, block_id, category_id, cpm)
select page_id, block_id,
CASE
$case    ELSE 0
END AS category_id,
min(cpm) as cpm
from articles
group by 1,2,3
having category_id > 0
";

    if ($opts->{sql}) {
        print $sql;
    } elsif ($opts->{commit}) {
        $app->partner_db->transaction(
            sub {
                $app->partner_db->_do($sql);
            }
        );
    } else {
        warn "no action\n";
    }
}

sub args {
    my ($opts) = @_;

    return (
        'sql!'    => \$opts->{sql},
        'commit!' => \$opts->{commit},
    );
}
