replace INTO statistics_reports (`id`, `level`, `caption_ru`, `caption_en`, `multistate`, `not_show`, `query`) values
(
    'outdoor_block_report_detailed_by_page_id',
    'outdoor_block',
    'Отчет по OutDoor ${page_id} «${name}» за ${period||7days}',
    'Report on OutDoor ${page_id} "${name}" report for ${period||7days}',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": [
            "AND",
            [
              [
                "page_id",
                "=",
                "${page_id}"
              ]
            ]
          ]
        }
      ],
      "top_keys": 3,
      "period": "${period||7days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "outdoor_block_hits",
        "outdoor_block_shows",
        "outdoor_block_all_hits",
        "outdoor_partner_wo_nds",
        "outdoor_all_wo_nds",
        "outdoor_block_visibility",
        "outdoor_block_winrate",
        "outdoor_block_cpm_partner_wo_nds",
        "outdoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "outdoor_block",
          "filter": [
            "AND",
            [
              [
                "page_id",
                "=",
                "${page_id}"
              ]
            ]
          ]
        }
      ],
      "order_by": [],
      "period": "${period||7days}"
    }
  ],
  "isLevelsDifferent": true
}
'
),(
    'indoor_block_report_detailed_by_page_id',
    'indoor_block',
    'Отчет по InDoor ${page_id} «${name}» за ${period||7days}',
    'Report on InDoor ${page_id} "${name}" report for ${period||7days}',
    1, 0, '
{
  "chartLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": [
            "AND",
            [
              [
                "page_id",
                "=",
                "${page_id}"
              ]
            ]
          ]
        }
      ],
      "top_keys": 3,
      "period": "${period||7days}"
    }
  ],
  "tableLevel": [
    {
      "fields": [
        "indoor_block_hits",
        "indoor_block_shows",
        "indoor_block_all_hits",
        "indoor_partner_wo_nds",
        "indoor_all_wo_nds",
        "indoor_block_visibility",
        "indoor_block_winrate",
        "indoor_block_cpm_partner_wo_nds",
        "indoor_block_cpm_all_wo_nds"
      ],
      "dimension_fields": [
        "date|day",
        "currency_id"
      ],
      "dimension_filter": null,
      "entity_fields": [],
      "vat": -1,
      "levels": [
        {
          "id": "indoor_block",
          "filter": [
            "AND",
            [
              [
                "page_id",
                "=",
                "${page_id}"
              ]
            ]
          ]
        }
      ],
      "order_by": [],
      "period": "${period||7days}"
    }
  ],
  "isLevelsDifferent": true
}
'
)
;
