#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'

YT_TABLE_TNS_PATH="${YT_PROJECT_PATH}/tns"
YT_TABLE_TNS_SCHEMA='[{name=id;type=uint16;sort_order=ascending;required=%true};{name=TNSID;type=int16;required=%true};{name=TNS_name_ru;type=string;required=%true};{name=TNS_name_eng;type=string;required=%true}]'

YT_TABLE_IAB_PATH="${YT_PROJECT_PATH}/iab"
YT_TABLE_IAB_SCHEMA='[{name=id;type=uint16;sort_order=ascending;required=%true};{name=IABid;type=uint16;required=%true};{name=parent_id;type=uint16};{name=level;type=uint8;required=%true};{name=show_in_pi;type=uint8;required=%true};{name=IAB_name_en;type=string;required=%true};{name=IAB_name_ru;type=string}]'

TABLE_PATHS=("$YT_TABLE_TNS_PATH" "$YT_TABLE_IAB_PATH")
TABLE_SCHEMAS=("$YT_TABLE_TNS_SCHEMA" "$YT_TABLE_IAB_SCHEMA")
TABLE_DATA=("PI-15576_dict_tns.json" "PI-15576_dict_iab.json")

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'
else
    echo "~using TEST config";
fi

YT_REPLICA_CLUSTERS=("$YT_REPLICA_CLUSTER_1" "$YT_REPLICA_CLUSTER_2")

for ((i=0; i < ${#TABLE_PATHS[@]}; i++))
do
YT_TABLE_PATH=${TABLE_PATHS[$i]}
YT_TABLE_DATA="migrations/before_release/${TABLE_DATA[$i]}"
YT_TABLE_SCHEMA=${TABLE_SCHEMAS[$i]}

for ((j=0; j < ${#YT_REPLICA_CLUSTERS[@]}; j++))
do
YT_REPLICA_CLUSTER=${YT_REPLICA_CLUSTERS[$j]}

yt remove $YT_TABLE_PATH --force --proxy $YT_REPLICA_CLUSTER 2>/dev/null || true

TABLE_ID=$( \
    yt create table $YT_TABLE_PATH --force --attr "{
       dynamic=%false;
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER
); echo $TABLE_ID

cat $YT_TABLE_DATA | yt write-table "$YT_TABLE_PATH" --format='<encode_utf8=false;enable_string_to_all_conversion=true>json' --proxy $YT_REPLICA_CLUSTER
done

done
exit 0;
