#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'

YT_TABLE_TNS_IAB_PATH="${YT_PROJECT_PATH}/tns_iab_mapping"
YT_TABLE_IAB_BM_CATEGORY_PATH="${YT_PROJECT_PATH}/iab_bm_category_mapping"

TABLE_PATHS=("$YT_TABLE_TNS_IAB_PATH" "$YT_TABLE_IAB_BM_CATEGORY_PATH")
TABLE_DATA=("PI-15576_tns_iab_map.json" "PI-15576_iab_bm_map.json")

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'
else
    echo "~using TEST config";
fi

for ((i=0; i < ${#TABLE_PATHS[@]}; i++))
do
YT_TABLE_PATH=${TABLE_PATHS[$i]}
YT_TABLE_DATA="migrations/before_release/${TABLE_DATA[$i]}"

yt select "id from [$YT_TABLE_PATH]" --format json --proxy $YT_META_CLUSTER | yt delete-rows $YT_TABLE_PATH  --no-require-sync-replica  --format json  --proxy $YT_META_CLUSTER
cat $YT_TABLE_DATA | yt insert-rows $YT_TABLE_PATH  --no-require-sync-replica --format json  --proxy $YT_META_CLUSTER
yt select "* from [$YT_TABLE_PATH] order by id desc limit 10" --format json --proxy $YT_META_CLUSTER
done
exit 0;
