#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner'

YT_TABLE_PATH="${YT_PROJECT_PATH}/domains_for_news"
YT_TABLE_SCHEMA='[
  {name=host; type=string; sort_order=ascending; required=%true};
  {name=start; type=uint32};
  {name=end; type=uint32}
]'

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='banach'
    YT_REPLICA_CLUSTER_3='arnold'
else
    echo "~using TEST config";
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
fi

TABLE_ID_1=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%false;
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_1
);
echo "Table on $YT_REPLICA_CLUSTER_1 is $TABLE_ID_1"

if [ $YT_REPLICA_CLUSTER_2 ];
then
  TABLE_ID_2=$( \
      yt create table $YT_TABLE_PATH --attr "{
         dynamic=%false;
         schema=$YT_TABLE_SCHEMA
      }" --proxy $YT_REPLICA_CLUSTER_2
  );
  echo "Table on $YT_REPLICA_CLUSTER_2 is $TABLE_ID_2"
fi

if [ $YT_REPLICA_CLUSTER_3 ];
then
  TABLE_ID_3=$( \
      yt create table $YT_TABLE_PATH --attr "{
         dynamic=%false;
         schema=$YT_TABLE_SCHEMA
      }" --proxy $YT_REPLICA_CLUSTER_3
  );
  echo "Table on $YT_REPLICA_CLUSTER_3 is $TABLE_ID_3"
fi

exit 0;
