use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $user_ids = $app->partner_db->user_features->get_all(
            fields => [qw(user_id)],
            filter => ['feature' => '=' => \'format_system']
        );
        my @user_ids = map {$_->{user_id}} @$user_ids;

        my $block_list = $app->context_on_site_rtb->get_all(
            "fields" => ["*"],
            "filter" => [
                'AND',
                [['site_version' => '=' => 'turbo_desktop'], [page => 'MATCH' => [owner_id => 'IN' => \@user_ids]]],
            ]
        );

        my $table_templates   = $app->partner_db->design_templates;
        my $field_map         = $app->context_on_site_rtb->get_design_fields_map();
        my %reverce_field_map = reverse %$field_map;

        foreach my $block (@$block_list) {
            $app->partner_db->transaction(
                sub {

                    print logstr("Convert designs for block $block->{public_id}");
                    foreach my $template (@{$block->{design_templates}}) {

                        $block->{page_id} = $block->{campaign_id};

                        $template->{form_factor} //= 'vertical';

                        my $design;
                        foreach (keys %{$template->{design_settings}}) {
                            $design->{$reverce_field_map{$_}} = $template->{design_settings}->{$_}
                              if defined $reverce_field_map{$_};
                        }
                        $design = $app->context_on_site_rtb->_get_fixed_bk_direct_design(
                            {
                                page_id      => $block->{page_id},
                                id           => $block->{id},
                                site_version => $block->{site_version},
                                %$design
                            }
                        );

                        if ($design->{name} eq 'extensibleMobile' || $design->{name} eq 'motion') {
                            $design->{name}            = 'motion';
                            $design->{limit}           = 1;
                            $design->{horizontalAlign} = JSON::XS::true;
                            $template->{form_factor}   = 'horizontal' if $template->{form_factor} eq 'vertical';
                        }

                        $design->{limit} += 0;
                        foreach (qw(fontSize width height)) {
                            $design->{$_} += 0 if defined($design->{$_});
                        }

                        foreach (keys %$design) {
                            delete $design->{$_} unless defined $design->{$_};
                        }

                        $template->{design_settings} = $design;

                        my $id = delete $template->{id};
                        delete $template->{$_} foreach (qw(page_id block_id order_num));
                        $table_templates->edit({id => $id}, {'opts' => to_json($template)});
                    }

                  }

            );
        }
    }
   );
