#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт заменяет конкретные значения grid_columns и grid_rows на плейсхолдеры в шаблонах контентных блоков и при необходимости изменяет значения grid_columns и grid_rows на блоке

=head1 USAGE

  perl -Ilib bin/oneshots/PI-18110_update_templates_for_content_block.pl
  perl -Ilib bin/oneshots/PI-18110_update_templates_for_content_block.pl \
        --rollback=PI-18110_update_templates_for_content_block.out

=head1 OPTIONS

  rollback   - имя предыдущего лог-файла, откат действий

=cut

use qbit;

use utf8;
use Utils::PublicID 'split_block_public_id';
use Utils::ScriptWrapper;

sub args {
    my ($opts) = @_;

    return ('rollback:s' => \$opts->{rollback},);
}
my ($app, $opts);
run(
    sub {
        ($app, $opts) = @_;

        my %blocks;
        my %pages;
        if ($opts->{rollback}) {
            my $fh;
            if (open($fh, '<', $opts->{rollback})) {
                my %old_blocks;
                while (<$fh>) {
                    if (/Old block data:\s+(\S+)\s+(\S+)\s+(.+)$/) {

                        my $table_name = $1;
                        my $block_id   = from_json($2);
                        my $block_data = $3;
                        $app->partner_db->$table_name->edit($block_id, {opts => $block_data});
                    }
                }
                close $fh;
            } else {
                print logstr 'Can\'t open log-file for rollback: ', $!;
                return;
            }
        } else {
            foreach my $table_name (
                qw(context_on_site_content internal_context_on_site_content context_on_site_natural internal_context_on_site_natural)
              )
            {
                my $table            = $app->partner_db->$table_name;
                my $pk               = $table->primary_key();
                my $block_data_query = $app->partner_db->query->select(
                    table  => $table,
                    fields => [@$pk, 'opts'],
                );

                print $block_data_query->get_sql_with_data(), "\n";
                my $block_data = $block_data_query->get_all();

                foreach my $block (@$block_data) {
                    update_block($table, $block);
                }
            }
        }
    }
   );

sub update_block {
    my ($table, $block) = @_;

    my $opts = delete $block->{opts};
    utf8::decode($opts) unless utf8::is_utf8($opts);
    $opts = from_json($opts);

    my $template = $opts->{template};
    return unless $template;
    my $grid_columns = $opts->{grid_columns};
    my $grid_rows    = $opts->{grid_rows};

    my $template_rows    = 0;
    my $template_columns = 0;
    return unless $template =~ /<ya-units-grid/;
    print logstr "Old block data:", $table->name(), $block, $opts;
    if ($template =~ /<ya-units-grid[^>]*rows="(\d+)"/m) {
        $template_rows = $1;
    }
    if ($template =~ /<ya-units-grid[^>]*cols="(\d+)"/m) {
        $template_columns = $1;
    }
    if (!($template_rows && $template_columns) && $template =~ /<ya-units-grid\s+sizes="[^">]*(\d+)x(\d+)\s*"/m) {
        $template_rows    = $1;
        $template_columns = $2;
    }
    $template =~ s/(<ya-units-grid[^>]*rows=\\?")(\d+)(\\?")/$1\${grid_rows}$3/mg;
    $template =~ s/(<ya-units-grid[^>]*cols=\\?")(\d+)(\\?")/$1\${grid_columns}$3/mg;
    $template =~ s/(<ya-units-grid\s+sizes="[^">]*)(\d+)x(\d+)(\s*")/$1\${grid_rows}x\${grid_columns}$4"/mg;

    my $new_grid_rows    = 0;
    my $new_grid_columns = 0;
    if ($template_columns && $template_rows && $grid_columns * $grid_rows > $template_columns * $template_rows) {
        $new_grid_columns = $template_columns;
        $new_grid_rows    = $template_rows;
        print logstr "Changed block:", $table->name(), $block, $grid_rows, $grid_columns, $template_rows,
          $template_columns, $new_grid_rows, $new_grid_columns;
        $grid_rows    = $new_grid_rows;
        $grid_columns = $new_grid_columns;
    }

    $opts->{template}     = $template;
    $opts->{grid_rows}    = $grid_rows;
    $opts->{grid_columns} = $grid_columns;

    $table->edit($block, {opts => to_json($opts)});
}
