#!/bin/bash

echo '-=-=-=- TS -=-=-=-'

# Создание топика
logbroker -s logbroker schema create topic /partner/test/dsp -p 2 --abc-service partnjorskijjinterfejjsjandeksa --responsible 'partners-dev@' -y

# Добавление нашего консьюмера читателем на новый топик
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer /partner/test/partner-consumer --all-original -y

# Предоставление логфеллерному приложению прав начтение топик
logbroker -s logbroker permissions grant --path /partner/test/dsp --subject 2001185@tvm --permissions ReadTopic -y

# Добавление консьюмеров логфеллера
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer shared/logfeller-synchronizer --all-original -y
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer shared/hahn-logfeller-shadow --mirror-to-cluster sas -y
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer shared/hahn-logfeller --mirror-to-cluster sas -y
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer shared/arnold-logfeller-shadow --mirror-to-cluster vla -y
logbroker -s logbroker schema create read-rule --topic /partner/test/dsp --consumer shared/arnold-logfeller --mirror-to-cluster vla -y

# Вывод результата
logbroker -s logbroker schema describe /partner/test/dsp

echo '-=-=-=- PROD -=-=-=-'

# Создание топика
logbroker -s logbroker schema create topic /partner/prod/dsp -p 2 --abc-service partnjorskijjinterfejjsjandeksa --responsible 'partners-dev@' -y

# Добавление нашего консьюмера читателем на новый топик
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer /partner/prod/partner-consumer --all-original -y

# Предоставление логфеллерному приложению прав начтение топик
logbroker -s logbroker permissions grant --path /partner/prod/dsp --subject 2001185@tvm --permissions ReadTopic -y

# Добавление консьюмеров логфеллера
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer shared/logfeller-synchronizer --all-original -y
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer shared/hahn-logfeller-shadow --mirror-to-cluster sas -y
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer shared/hahn-logfeller --mirror-to-cluster sas -y
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer shared/arnold-logfeller-shadow --mirror-to-cluster vla -y
logbroker -s logbroker schema create read-rule --topic /partner/prod/dsp --consumer shared/arnold-logfeller --mirror-to-cluster vla -y

# Вывод результата
logbroker -s logbroker schema describe /partner/prod/dsp

echo '-=-=-=- END -=-=-=-'
