#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт фиксит bk_data и добавляет design_templates если их нет

=head1 USAGE

    perl -I./lib ./migrations/before_release/PI-17316_fix_design_templates_and_bk_data.pl
    perl -I./lib ./migrations/before_release/PI-17316_fix_design_templates_and_bk_data.pl --page_ids=12312,534142

=head1 OPTIONS

    page_ids   - ограничить работу скрипта только указанными пейджами

=cut

use qbit;
use Utils::ScriptWrapper;

my $LIMIT = 10_000;

sub args {
    my ($opts) = @_;

    return ('page_ids:s' => \$opts->{page_ids},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my @page_ids = split(/,/, $opts->{'page_ids'} // '');

        foreach my $block_accessor (qw(context_on_site_rtb internal_context_on_site_rtb)) {
            my $block_model = $app->$block_accessor;

            my $count  = 0;
            my $offset = 0;
            while (TRUE) {
                my @page_ids = map {$_->{'page_id'}} @{
                    $block_model->page->get_all(
                        fields => [qw(page_id)],
                        (@page_ids ? (filter => {page_id => \@page_ids}) : ()),
                        limit  => $LIMIT,
                        offset => $offset
                    )
                  };

                last unless @page_ids;

                $offset += @page_ids;
                print logstr('DATE:', curdate(oformat => 'db_time'), 'MODEL:', $block_accessor, 'COUNT:', $offset);

                my $blocks = $block_model->get_all(
                    fields => [qw(*)],
                    filter => {
                        ($block_accessor eq 'context_on_site_rtb' ? (is_constructed_format => FALSE) : ()),
                        page_id => \@page_ids
                    }
                );

                my @data_to_add;
                foreach my $block (@$blocks) {

                    _create_designs($block_model, $block) if $block->{'is_custom_bk_data'} && $block->{'bk_data'};

                    next
                      if defined $block->{design_templates} && @{$block->{design_templates}};

                    my $design_settings;
                    try {
                        $design_settings = $block_model->_get_design_settings($block);
                    }
                    catch {
                        print STDERR logstr('ERROR:',           shift->message);
                        print STDERR logstr('INCORRECT_BLOCK:', $block);
                    };

                    next unless defined($design_settings);

                    push @data_to_add,
                      {
                        page_id     => $block->{'page_id'},
                        block_id    => $block->{id},
                        caption     => 'default design template',
                        order_num   => 0,
                        update_time => curdate(oformat => 'db_time'),
                        opts        => to_json(
                            {
                                design_settings         => $design_settings,
                                form_factor             => $block->{form_factor},
                                is_custom_format_direct => $block->{is_custom_format_direct},
                            },
                            pretty => TRUE
                        )
                      };
                }

                if (@data_to_add) {
                    $count += scalar(@data_to_add);

                    $app->partner_db->design_templates->add_multi(\@data_to_add);
                }
            }

            print logstr('ADDED:', $count, $block_accessor);
        }
    }
   );

sub _create_designs {
    my ($block_model, $block) = @_;

    my $bk_data = from_json($block->{'bk_data'});

    my @set_designs = $block_model->get_bk_data_design_ids($bk_data);

    if (@set_designs) {
        my %exists_designs = map {$_->{'id'} => $_} @{$block->{'design_templates'}};

        my @not_found = grep {!exists($exists_designs{$_})} @set_designs;

        if (@not_found) {
            my $design_field = $block_model->design_field();

            my $designs = $block_model->partner_db->design_templates->get_all(filter => ['id', 'IN', \\@not_found]);

            my %map_ids = ();
            foreach my $design (@$designs) {
                my $old_id = delete($design->{'id'});

                $design->{'page_id'}     = $block->{'page_id'};
                $design->{'block_id'}    = $block->{'id'};
                $design->{'multistate'}  = 0;
                $design->{'update_time'} = curdate(oformat => 'db_time');

                my $new_id = $block_model->partner_db->design_templates->add($design);
                $map_ids{$old_id} = $new_id;

                $bk_data->{$design_field}{$new_id} = delete($bk_data->{$design_field}{$old_id});
            }

            print logstr('UPDATE:', $block, 'BK_DATA:', to_json(from_json($block->{'bk_data'})), 'MAP:', \%map_ids);

            $block_model->partner_db_table->edit($block, {bk_data => to_json($bk_data, pretty => TRUE)});
        }
    }
}
