#!/usr/bin/perl

# Usage:
#   ./migrations/before_release/PI-18114_news_params.pl | mysql_partner2 --server=ts

use strict;
use warnings;

my $ADD_REQUEST = q[
UPDATE
    `%s`
SET
    `opts` = JSON_SET(
        `opts`,
        '$.add_url_parameter', 1,
        '$.doc_source',        'web',
        '$.news_params',       JSON_OBJECT(
            'candidates',     IF(
                    opts->'$.candidates' is not null
                AND
                    JSON_TYPE(opts->'$.candidates') <> 'NULL',
                opts->'$.candidates',
                JSON_ARRAY()
            ),
            'filter_clicked', 0,
            'model_type',     'ctr'
        )
    )
;
];

my $UPDATE_REQUEST = q[
UPDATE
    `%s`
SET
    `opts` = JSON_SET(
        `opts`,
        '$.news_params.candidates[%d].tags_blacklist',         JSON_ARRAY(),
        '$.news_params.candidates[%d].url_prefixes',           JSON_ARRAY(),
        '$.news_params.candidates[%d].url_prefixes_blacklist', JSON_ARRAY()
    )
WHERE
    JSON_LENGTH(opts->'$.news_params.candidates') > %d
;
];

my $REMOVE_REQUEST = q[
UPDATE
    `%s`
SET
    `opts` = JSON_REMOVE(`opts`, '$.candidates')
;
];

foreach my $table_name (qw(context_on_site_content internal_context_on_site_content)) {
    printf($ADD_REQUEST, $table_name);
    foreach (0 .. 9) {
        printf($UPDATE_REQUEST, $table_name, ($_) x 4);
    }
    printf($REMOVE_REQUEST, $table_name);
}
