#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner'

YT_TABLE_PATH="${YT_PROJECT_PATH}/recommendation_widget_fast_ban"
YT_TABLE_SCHEMA='[{name=id;type=uint64;sort_order=ascending;required=%true};{name=create_date;type=string;required=%true};{name=model;type=string;required=%true};{name=domain;type=string;required=%true};{name=page_id;type=uint64;required=%true};{name=block_id;type=uint64;required=%true};{name=url_md5_hex;type=string;required=%true};{name=url;type=string;required=%true}]'

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'
else
    echo "~using TEST config";
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
fi

TABLE_ID_1=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%false;
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_1
); echo $TABLE_ID_1

TABLE_ID_2=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%false;
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_2
); echo $TABLE_ID_2

exit 0;
