#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Архивируем промо блоки

=head1 USAGE

    perl -I./lib ./migration/before_release/PI-16868_remove_access_for_stripe.pl

=head1 OPTIONS

    commit - внести изменения

=cut

use lib::abs qw(../../lib);
use qbit;

use Utils::ScriptWrapper;

run(\&main);

sub main {
    my ($app, $opts) = @_;
    my $model = $app->context_on_site_stripe;
    my $list = $model->get_all(fields => ["public_id", "page_id"], filter => {multistate => "not deleted"});
    my %pages;
    for my $row (@$list) {
        $pages{$row->{page_id}} = undef;
        print logstr("BLOCK", $row->{public_id});
        $model->do_action($row->{public_id}, "delete", do_not_update_in_bk => 1) if $opts->{commit};
    }

    my @pages = keys %pages;
    $app->all_pages->mark_pages_for_async_update(page_ids => \@pages) if $opts->{commit};
    for my $page_id (@pages) {
        print logstr("PAGE", $page_id);
    }
}
