#Проставляем дизайны для блоков в годмоде
insert into design_templates
(
    `page_id`,
    `block_id`,
    `caption`,
    `order_num`,
    `opts`,
    `update_time`,
    `multistate`,
    `type`
)
(
    select
        campaign_id,
        id,
        'Основной дизайн',
        1,
        json_set(
            '{"filter_tags": null, "is_custom_format_direct": "0"}',
            '$.design_settings',
            json_set(
                json_remove(bk_data->>'$.RtbDesign."0".design','$.blockId','$.Width'),
                '$.limit', bk_data->>'$.RtbDesign."0".design.limit' + 0,
                '$.width', ifnull(bk_data->>'$.RtbDesign."0".design.width',bk_data->>'$.RtbDesign."0".design.Width') + 0,
                '$.height', bk_data->>'$.RtbDesign."0".design.height' + 0,
                '$.fontSize', bk_data->>'$.RtbDesign."0".design.fontSize' + 0,
                '$.titleFontSize', bk_data->>'$.RtbDesign."0".design.titleFontSize' + 0,
                '$.imageHeight', bk_data->>'$.RtbDesign."0".design.imageHeight' + 0,
                '$.imageWidth', bk_data->>'$.RtbDesign."0".design.imageWidth' + 0,
                '$.advSpacing', bk_data->>'$.RtbDesign."0".design.advSpacing' + 0
            )
        ),
        sysdate(),
        0,
        'tga'
    from
        context_on_site_rtb
    where
        (campaign_id ,id) not in (select page_id,block_id from design_templates where multistate =0) and is_custom_bk_data
);

#Удаляем пустые значения
update
    design_templates
set
    opts = json_remove(opts,'$.design_settings.fontSize')
where
    page_id in (184593,188382) and
    (opts->>'$.design_settings.fontSize' is null or
    opts->>'$.design_settings.fontSize' = 'null');

update
    design_templates
set
    opts = json_remove(opts,'$.design_settings.titleFontSize')
where
    page_id in (184593,188382) and
    (opts->>'$.design_settings.titleFontSize' is null or
    opts->>'$.design_settings.titleFontSize' = 'null');

update
    design_templates
set
    opts = json_remove(opts,'$.design_settings.imageHeight')
where
    page_id in (184593,188382) and
    (opts->>'$.design_settings.imageHeight' is null or
    opts->>'$.design_settings.imageHeight' = 'null');

update
    design_templates
set
    opts = json_remove(opts,'$.design_settings.imageWidth')
where
    page_id in (184593,188382) and
    (opts->>'$.design_settings.imageWidth' is null or
    opts->>'$.design_settings.imageWidth' = 'null');

update
    design_templates
set
    opts = json_remove(opts,'$.design_settings.advSpacing')
where
    page_id in (184593,188382) and
    (opts->>'$.design_settings.advSpacing' is null or
    opts->>'$.design_settings.advSpacing' = 'null');

select
    campaign_id,
    id
from
    context_on_site_rtb
where
    (campaign_id ,id) not in (select page_id,block_id from design_templates where multistate =0) and is_custom_bk_data;
