#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_LIST=('freud' 'hume')

YT_PROJECT_PATH='//home/partner/dict'

YT_TABLE_PATH_LIST=("${YT_PROJECT_PATH}/pages" "${YT_PROJECT_PATH}/page_tags" "${YT_PROJECT_PATH}/block_tags")
YT_TABLE_SCHEMA_LIST=(
'[{name=page_id;type=uint32;sort_order=ascending;required=%true};
{name=caption;type=string;required=%true};
{name=domain;type=string;required=%true};
{name=login;type=string;required=%true}]'
'[{name=page_id;type=uint32;sort_order=ascending;required=%true};
{name=tags;type=string;sort_order=ascending;required=%true};
{name=service;type=string;required=%false};
{name=nk;type=string;required=%false}]'
'[{name=page_id;type=uint32;sort_order=ascending;required=%true};{name=block_id;type=uint8;sort_order=ascending;required=%true};{name=tags;type=string;sort_order=ascending;required=%true};{name=nk;type=string;required=%false}]'
)

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_LIST=('hahn' 'arnold')
else
    echo "~using TEST config";
    for i in {0..2}
    do
        YT_TABLE_PATH="${YT_TABLE_PATH_LIST[$i]}"
        for replica in "${YT_REPLICA_LIST[@]}" $YT_META_CLUSTER
        do
            yt remove $YT_TABLE_PATH --proxy $replica 2>/dev/null || true
        done
    done
fi

for i in {0..2}
do
    YT_TABLE_PATH="${YT_TABLE_PATH_LIST[$i]}"
    YT_TABLE_SCHEMA="${YT_TABLE_SCHEMA_LIST[$i]}"

    REPLICATED_TABLE_ID=$(\
        yt create replicated_table $YT_TABLE_PATH --attr "{
          dynamic=%true;
          schema=$YT_TABLE_SCHEMA
        }"  --proxy $YT_META_CLUSTER
    ); echo $REPLICATED_TABLE_ID

    for CLUSTER_NAME in "${YT_REPLICA_LIST[@]}"
    do
        REPLICA_ID=$( \
            yt create table_replica --attr "{
                table_path=\"$YT_TABLE_PATH\";
                cluster_name=$CLUSTER_NAME;
                replica_path=\"$YT_TABLE_PATH\"
            }" --proxy $YT_META_CLUSTER
        ); echo $REPLICA_ID
        TABLE_ID=$( \
            yt create table $YT_TABLE_PATH --attr "{
               dynamic=%true;
               upstream_replica_id=\"$REPLICA_ID\";
               schema=$YT_TABLE_SCHEMA
            }" --proxy $CLUSTER_NAME
        ); echo $TABLE_ID

        yt mount-table $YT_TABLE_PATH --proxy $CLUSTER_NAME
        yt alter-table-replica "$REPLICA_ID" --enable --mode sync --proxy $YT_META_CLUSTER
    done

    yt mount-table $YT_TABLE_PATH --proxy $YT_META_CLUSTER

done
exit
