#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_REPLICA_LIST=('freud' 'hume')
YT_PROJECT_PATH='//home/partner'
YT_TABLE_PATH_LIST=("${YT_PROJECT_PATH}/domains_for_webmaster")
YT_TABLE_SCHEMA_LIST=(
'[{name=domain;type=string;sort_order=ascending;required=%true};
{name=is_mirror;type=boolean;required=%true}]'
)

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_REPLICA_LIST=('hahn' 'arnold')
else
    echo "~using TEST config";
fi

for i in {0..0}
do
    YT_TABLE_PATH="${YT_TABLE_PATH_LIST[$i]}"
    for replica in "${YT_REPLICA_LIST[@]}" $YT_META_CLUSTER
    do
        yt remove $YT_TABLE_PATH --proxy $replica 2>/dev/null || true
    done
done

for i in {0..0}
do
    YT_TABLE_PATH="${YT_TABLE_PATH_LIST[$i]}"
    YT_TABLE_SCHEMA="${YT_TABLE_SCHEMA_LIST[$i]}"

    for CLUSTER_NAME in "${YT_REPLICA_LIST[@]}"
    do
        TABLE_ID=$( \
            yt create table $YT_TABLE_PATH --attr "{
               dynamic=%false;
               schema=$YT_TABLE_SCHEMA
            }" --proxy $CLUSTER_NAME
        ); echo $TABLE_ID
    done
done
exit
