CREATE TABLE IF NOT EXISTS `video_scenaries` (
    `page_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL,
    `opts` JSON NOT NULL,
    `multistate` BIGINT NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    PRIMARY KEY (`page_id`, `id`),
    INDEX `video_scenaries__multistate` (`multistate`),
    INDEX `video_scenaries__id` (`id`),
    FOREIGN KEY `fk_video_scenaries__page_id___video_an_site__id` (`page_id`)
        REFERENCES `video_an_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `video_scenaries_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_page_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `video_scenaries_action_log__dt_elem_page_id_elem_id_action` (`dt`, `elem_page_id`, `elem_id`, `action`),
    INDEX `video_scenaries_action_log__elem_page_id_elem_id_action` (`elem_page_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_video_scenaries_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_video_scenaries_action_log__elem_page_id_elem_id___video_sce` (`elem_page_id`, `elem_id`)
        REFERENCES `video_scenaries` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `video_an_site_scenario_seq` (
    `site_id` INT UNSIGNED NOT NULL,
    `next_scenario_id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`site_id`),
    FOREIGN KEY `fk_video_an_site_scenario_seq__site_id___video_an_site__id` (`site_id`)
        REFERENCES `video_an_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

ALTER TABLE `video_an_site_instream`
ADD COLUMN `vmap_id` INT UNSIGNED NOT NULL AFTER `page_id`;

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

UPDATE `video_an_site_instream` i SET `vmap_id` = (SELECT MAX(`vmap_id`) FROM (SELECT * FROM `video_an_site_instream`) AS t1 WHERE `page_id`=i.`page_id`)+1 WHERE `vmap_id` = 0 AND `category_id` IN (SELECT MIN(`category_id`) FROM (SELECT * FROM `video_an_site_instream` WHERE `vmap_id`=0) AS t2 WHERE `page_id` = i.`page_id`);

INSERT INTO `video_scenaries` (SELECT `page_id`, `vmap_id`, CONCAT('Default scenario ',`vmap_id`) ,'{"single_ad_session":0,"use_better_places":0}', 2, SYSDATE() FROM `video_an_site_instream` GROUP BY `page_id`, `vmap_id`);

INSERT INTO `video_an_site_scenario_seq` (SELECT `page_id`, MAX(`id`)+1 FROM `video_scenaries` GROUP BY `page_id`);

ALTER TABLE `video_an_site_instream`
ADD FOREIGN KEY `fk_video_an_site_instream__page_id_vmap_id___video_scenaries__p` (`page_id`, `vmap_id`)
        REFERENCES `video_scenaries` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT;
